% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/efc.R
\docType{data}
\name{efc}
\alias{efc}
\title{Sample dataset from the EUROFAMCARE project}
\description{
Sample dataset from the EUROFAMCARE project
}
\note{
There are two further datasets, \code{efc2} and \code{efc3}, which
        slightly differ in their structure. \code{efc2} has already attached
        variable label attributes to each variable. In \code{efc3}, categorical
        variables have been converted to labelled factors, i.e. value labels
        are set as factor levels. However, factors in \code{efc3} no longer
        have variable label attributes.
}
\examples{
# Attach EFC-data
data(efc)

# Show structure
str(efc)

# show first rows
head(efc)

# show variables
\dontrun{
view_spss(efc)

# show variable labels
get_var_label(efc)

# plot efc-data frame summary
sjt.df(efc, alternateRowColor=TRUE)}
}
\references{
\url{http://www.uke.de/eurofamcare/}
}
\keyword{data}

