% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjTabPropTable.R
\name{sjt.xtab}
\alias{sjt.xtab}
\title{Summary of contingency tables as HTML table}
\usage{
sjt.xtab(var.row, var.col, weight.by = NULL, title = NULL,
  var.labels = NULL, value.labels = NULL, wrap.labels = 20,
  show.obs = TRUE, show.cell.prc = FALSE, show.row.prc = FALSE,
  show.col.prc = FALSE, show.exp = FALSE, show.summary = TRUE,
  show.legend = FALSE, show.na = FALSE, string.total = "Total",
  digits = 1, tdcol.n = "black", tdcol.expected = "#339999",
  tdcol.cell = "#993333", tdcol.row = "#333399", tdcol.col = "#339933",
  emph.total = FALSE, emph.color = "#f8f8f8", prc.sign = "&nbsp;&#37;",
  hundret = "100.0", CSS = NULL, encoding = NULL, file = NULL,
  use.viewer = TRUE, no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{var.row}{variable that should be displayed in the table rows.}

\item{var.col}{variable that should be displayed in the table columns.}

\item{weight.by}{weight factor that will be applied to weight all cases.
Must be a vector of same length as the input vector. Default is 
\code{NULL}, so no weights are used.}

\item{title}{table caption. By default, \code{title = NULL}, hence no title will be used.}

\item{var.labels}{character vector with variable names, which will be used 
to label variables in the output.}

\item{value.labels}{character vector (or \code{list} of character vectors)
with value labels of the supplied variables, which will be used 
to label variable values in the output.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis 
labels are displayed in one line and when a line break is inserted.}

\item{show.obs}{logical, if \code{TRUE}, observed values are shown}

\item{show.cell.prc}{logical, if \code{TRUE}, cell percentage values are shown}

\item{show.row.prc}{logical, if \code{TRUE}, row percentage values are shown}

\item{show.col.prc}{logical, if \code{TRUE}, column percentage values are shown}

\item{show.exp}{logical, if \code{TRUE}, expected values are also shown}

\item{show.summary}{If \code{TRUE} (default), a summary row with total and valid N as well as mean and
standard deviation is shown.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{show.na}{logical, if \code{TRUE}, \code{\link{NA}}'s (missing values)
are added to the output.}

\item{string.total}{label for the total column / row header}

\item{digits}{numeric, amount of digits after decimal point when rounding estimates and values.}

\item{tdcol.n}{Color for highlighting count (observed) values in table cells. Default is black.}

\item{tdcol.expected}{Color for highlighting expected values in table cells. Default is cyan.}

\item{tdcol.cell}{Color for highlighting cell percentage values in table cells. Default is red.}

\item{tdcol.row}{Color for highlighting row percentage values in table cells. Default is blue.}

\item{tdcol.col}{Color for highlighting column percentage values in table cells. Default is green.}

\item{emph.total}{logical, if \code{TRUE}, the total column and row will be emphasized with a
different background color. See \code{emph.color}.}

\item{emph.color}{logical, if \code{emph.total = TRUE}, this color value will be used
for painting the background of the total column and row. Default is a light grey.}

\item{prc.sign}{The percentage sign that is printed in the table cells, in HTML-format.
Default is \code{"&nbsp;\%"}, hence the percentage sign has a non-breaking-space after
the percentage value.}

\item{hundret}{Default value that indicates the 100-percent column-sums (since rounding values
may lead to non-exact results). Default is \code{"100.0"}.}

\item{CSS}{\code{\link{list}}-object with user-defined style-sheet-definitions, according to the 
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{encoding}{string, indicating the charset encoding used for variable and 
value labels. Default is \code{NULL}, so encoding will be auto-detected 
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{file}{destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and 
openend either in the IDE's viewer pane or the default web browser.}

\item{use.viewer}{If \code{TRUE}, the HTML table is shown in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Shows contingency tables as HTML file in browser or viewer pane, or saves them as file.
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
See 'Notes' in \code{\link{sjt.frq}}.
}
\examples{
# prepare sample data set
library(sjmisc)
data(efc)
efc.labels <- get_labels(efc)

# print simple cross table with labels
\dontrun{
sjt.xtab(efc$e16sex, efc$e42dep)
         
# print cross table with manually set
# labels and expected values
sjt.xtab(efc$e16sex, efc$e42dep, var.labels = c("Elder's gender", 
         "Elder's dependency"), value.labels = list(efc.labels[['e16sex']], 
         efc.labels[['e42dep']]), show.exp = TRUE)

# print minimal cross table with labels, total col/row highlighted
sjt.xtab(efc$e16sex, efc$e42dep, show.cell.prc = FALSE, emph.total = TRUE)

# User defined style sheet
sjt.xtab(efc$e16sex, efc$e42dep, 
         CSS = list(css.table = "border: 2px solid;",
                    css.tdata = "border: 1px solid;",
                    css.horline = "border-bottom: double blue;"))}

}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjt.xtab}{sjPlot manual: sjt.xtab}
           \item \code{\link{sjp.xtab}}
         }
}

