% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotOddsMultiple.R
\name{sjp.glmm}
\alias{sjp.glmm}
\title{Plot odds ratios (forest plots) of multiple fitted glm's}
\usage{
sjp.glmm(..., title = NULL, labelDependentVariables = NULL,
  legendDepVarTitle = "Dependent Variables", legendPValTitle = "p-level",
  stringModel = "Model", axisLabels.y = NULL, axisTitle.x = "Odds Ratios",
  axisLimits = NULL, breakTitleAt = 50, breakLabelsAt = 25,
  breakLegendTitleAt = 20, gridBreaksAt = 0.5, transformTicks = TRUE,
  geom.size = 3, geom.spacing = 0.4, geom.colors = "Set1",
  fade.ns = TRUE, usePShapes = FALSE, interceptLineType = 2,
  interceptLineColor = "grey70", coord.flip = TRUE, showIntercept = FALSE,
  showAxisLabels.y = TRUE, showValueLabels = TRUE, labelDigits = 2,
  showPValueLabels = TRUE, hideLegend = FALSE, facet.grid = FALSE,
  printPlot = TRUE)
}
\arguments{
\item{...}{one or more fitted glm-objects. May also be a \code{\link{list}}-object with
         fitted models, instead of separating each model with comma. See 'Examples'.}

\item{title}{diagram's title as string.}

\item{labelDependentVariables}{character vector with labels of dependent
variables of all fitted models. See 'Examples'.}

\item{legendDepVarTitle}{character vector used for the legend title.
Default is \code{"Dependent Variables"}.}

\item{legendPValTitle}{character vector used for the title of the significance level's legend.
Default is \code{"p-level"}. Only applies if \code{usePShapes = TRUE}.}

\item{stringModel}{string, legend text for the model names in case no
labels for the dependent variables are provided (see \code{labelDependentVariables}).
Default is \code{"Model"}.}

\item{axisLabels.y}{labels or names of the predictor variables (independent vars). Must
be a character vector of same length as independent variables. The labels
may also be passed as list object; they will be coerced to character vector automatically.}

\item{axisTitle.x}{string, title for the x axis.}

\item{axisLimits}{defines the range of the axis where coefficients and their confidence intervalls
are drawn. By default, the limits range from the lowest confidence interval to the highest one, so
the diagram has maximum zoom. Use your own values as vector of length two, indicating
lower and upper limit for the axis (for instance: \code{limits = c(-0.8, 0.8)}).}

\item{breakTitleAt}{determines how many chars of the plot title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in
one line and when a line break is inserted.}

\item{breakLegendTitleAt}{determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{gridBreaksAt}{set breaks for the y-axis, i.e. at every \code{gridBreaksAt}'th
position a major grid is being printed.}

\item{transformTicks}{logical, if \code{TRUE}, the grid lines have exponential
distances (equidistant), i.e. they visually have the same distance from
one panel grid to the next. If \code{FALSE}, grids are
plotted on every \code{gridBreaksAt}'s position, thus the grid lines become narrower with
higher odds ratio values.}

\item{geom.size}{size of the points that indicate the estimates. Default is 3.}

\item{geom.spacing}{spacing between the dots and error bars of the plotted fitted models. Default
is 0.3.}

\item{geom.colors}{colors for representing the estimates (i.e. points and error bars)
of the different fitted models. Thus, the length of this vector must be equal to
the length of supplied fitted models, so each model is represented by its own color.
See 'Note' in \code{\link{sjp.grpfrq}}.}

\item{fade.ns}{if \code{TRUE}, non significant estimates will be printed in slightly faded colors.}

\item{usePShapes}{If \code{TRUE}, significant levels are distinguished by different point shapes and a related
legend is plotted. Default is \code{FALSE}.}

\item{interceptLineType}{linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{color of the intercept line. Default value is \code{"grey70"}.}

\item{coord.flip}{logical, if \code{TRUE} (default), predictors are plotted along the y-axis and estimate
values are plotted on the x-axis.}

\item{showIntercept}{If \code{TRUE}, the intercept of the fitted model is also plotted.
Default is \code{FALSE}.}

\item{showAxisLabels.y}{Whether term names (predictor labels) should be shown or not.}

\item{showValueLabels}{logical, whether value labels should be plotted to each dot or not.}

\item{labelDigits}{amount of digits for rounding the estimates (see \code{showValueLabels}).
Default is 2, i.e. estimates have 2 digits after decimal point.}

\item{showPValueLabels}{Whether the significance levels of each coefficient should be appended
to values or not.}

\item{hideLegend}{logical, indicates whether legend (guide) should be shown or not.}

\item{facet.grid}{\code{TRUE} when each model should be plotted as single facet instead of
         an integrated single graph.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot odds ratios (forest plots) of multiple fitted glm's with confidence intervalls in one plot.
}
\examples{
# prepare dummy variables for binary logistic regression
y1 <- ifelse(swiss$Fertility < median(swiss$Fertility), 0, 1)
y2 <- ifelse(swiss$Infant.Mortality < median(swiss$Infant.Mortality), 0, 1)
y3 <- ifelse(swiss$Agriculture<median(swiss$Agriculture), 0, 1)

# Now fit the models. Note that all models share the same predictors
# and only differ in their dependent variable (y1, y2 and y3)
fitOR1 <- glm(y1 ~ swiss$Education + swiss$Examination + swiss$Catholic,
              family = binomial(link = "logit"))
fitOR2 <- glm(y2 ~ swiss$Education + swiss$Examination + swiss$Catholic,
              family = binomial(link = "logit"))
fitOR3 <- glm(y3 ~ swiss$Education + swiss$Examination + swiss$Catholic,
              family = binomial(link = "logit"))

# plot multiple models
sjp.glmm(fitOR1, fitOR2, fitOR3, facet.grid = TRUE, fade.ns = FALSE)

# plot multiple models with legend labels and point shapes instead of value  labels
sjp.glmm(fitOR1, fitOR2, fitOR3,
         labelDependentVariables = c("Fertility",
                                     "Infant Mortality",
                                     "Agriculture"),
         showValueLabels = FALSE,
         showPValueLabels = FALSE,
         usePShapes = TRUE)

# plot multiple models from nested lists parameter
all.models <- list()
all.models[[1]] <- fitOR1
all.models[[2]] <- fitOR2
all.models[[3]] <- fitOR3

sjp.glmm(all.models)
}

