% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_clean.R
\name{sits_clean}
\alias{sits_clean}
\alias{sits_clean.class_cube}
\alias{sits_clean.raster_cube}
\alias{sits_clean.derived_cube}
\alias{sits_clean.default}
\title{Cleans a classified map using a local window}
\usage{
sits_clean(
  cube,
  window_size = 5L,
  memsize = 4L,
  multicores = 2L,
  output_dir,
  version = "v1-clean",
  progress = TRUE
)

\method{sits_clean}{class_cube}(
  cube,
  window_size = 5L,
  memsize = 4L,
  multicores = 2L,
  output_dir,
  version = "v1-clean",
  progress = TRUE
)

\method{sits_clean}{raster_cube}(
  cube,
  window_size = 5L,
  memsize = 4L,
  multicores = 2L,
  output_dir,
  version = "v1-clean",
  progress = TRUE
)

\method{sits_clean}{derived_cube}(
  cube,
  window_size = 5L,
  memsize = 4L,
  multicores = 2L,
  output_dir,
  version = "v1-clean",
  progress = TRUE
)

\method{sits_clean}{default}(
  cube,
  window_size = 5L,
  memsize = 4L,
  multicores = 2L,
  output_dir,
  version = "v1-clean",
  progress = TRUE
)
}
\arguments{
\item{cube}{Classified data cube (tibble of class "class_cube").}

\item{window_size}{An odd integer  representing the size of the
sliding window of the modal function (min = 1, max = 15).}

\item{memsize}{Memory available for classification in GB
(integer, min = 1, max = 16384).}

\item{multicores}{Number of cores to be used for classification
(integer, min = 1, max = 2048).}

\item{output_dir}{Valid directory for output file.
(character vector of length 1).}

\item{version}{Version of the output file
(character vector of length 1)}

\item{progress}{Logical: Show progress bar?}
}
\value{
A tibble with an classified map (class = "class_cube").
}
\description{
Applies a modal function to clean up possible noisy pixels keeping
the most frequently values within the neighborhood.
In a tie, the first value of the vector is considered.
}
\examples{
if (sits_run_examples()) {
rf_model <- sits_train(samples_modis_ndvi, ml_method = sits_rfor)
# create a data cube from local files
data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
cube <- sits_cube(
    source = "BDC",
    collection = "MOD13Q1-6",
    data_dir = data_dir
)
# classify a data cube
probs_cube <- sits_classify(
    data = cube,
    ml_model = rf_model,
    output_dir = tempdir()
)
# label the probability cube
label_cube <- sits_label_classification(
    probs_cube,
    output_dir = tempdir()
)
# apply a mode function in the labelled cube
clean_cube <- sits_clean(
    cube = label_cube,
    window_size = 5,
    output_dir = tempdir(),
    multicores = 1
)
}

}
\author{
Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
