% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_segmentation.R
\name{sits_supercells}
\alias{sits_supercells}
\title{Segment an image using supercells}
\usage{
sits_supercells(
  tile = NULL,
  step = 50,
  compactness = 1,
  iter = 10,
  minarea = 30,
  multicores = 1
)
}
\arguments{
\item{tile}{Tile, bands, date to be segmented}

\item{step}{Distance (in number of cells) between initial
supercells' centers.}

\item{compactness}{A compactness value. Larger values cause clusters to
be more compact/even (square).}

\item{iter}{Number of iterations to create the output.}

\item{minarea}{Specifies the minimal size of a supercell (in cells).}

\item{multicores}{Number of cores for parallel processing}
}
\value{
Set of segments for a single tile
}
\description{
Apply a segmentation on a data cube based on the "supercells" package.
This is an adaptation and extension to remote sensing data of the
SLIC superpixels algorithm proposed by Achanta et al. (2012).
See references for more details.
}
\examples{
if (sits_run_examples()) {
data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
# create a data cube
cube <- sits_cube(
    source = "BDC",
    collection = "MOD13Q1-6",
    data_dir = data_dir
)

# segment the image
segments <- sits_segment(
    cube = cube,
    tile = "012010",
    bands = "NDVI",
    date = sits_timeline(cube)[1],
    seg_fn = sits_supercells(step = 10)
)
# create a classification model
rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
# get the average value per segment
samples_seg <- sits_get_data(
    cube = cube,
    samples = segments
)
# classify the segments
seg_class <- sits_classify(
    data = samples_seg,
    ml_model = rfor_model
)
# add a column to the segments by class
sf_seg <- sits_join_segments(
    data = seg_class,
    segments = segments
)
}
}
\references{
Achanta, Radhakrishna, Appu Shaji, Kevin Smith, Aurelien Lucchi,
        Pascal Fua, and Sabine Süsstrunk. 2012. “SLIC Superpixels Compared
        to State-of-the-Art Superpixel Methods.” IEEE Transactions on
        Pattern Analysis and Machine Intelligence 34 (11): 2274–82.

        Nowosad, Jakub, and Tomasz F. Stepinski. 2022. “Extended SLIC
        Superpixels Algorithm for Applications to Non-Imagery Geospatial
        Rasters.” International Journal of Applied Earth Observation
        and Geoinformation 112 (August): 102935.
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
