% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_smooth.R
\name{sits_smooth}
\alias{sits_smooth}
\title{Smooth probability cubes with spatial predictors}
\usage{
sits_smooth(
  cube,
  window_size = 9,
  neigh_fraction = 0.5,
  smoothness = 10,
  min_samples = 25,
  memsize = 4,
  multicores = 2,
  output_dir,
  version = "v1"
)
}
\arguments{
\item{cube}{Probability data cube.}

\item{window_size}{Size of the neighborhood.}

\item{neigh_fraction}{Fraction of neighbors with highest probability
to be used in Bayesian inference.}

\item{smoothness}{Estimated variance of logit of class probabilities
(Bayesian smoothing parameter). It can be either
a vector or a scalar.}

\item{min_samples}{Minimum number of samples to estimate normal
probability distribution for Bayesian inference.}

\item{memsize}{Maximum overall memory (in GB) to run the
smoothing.}

\item{multicores}{Number of cores to run the smoothing function}

\item{output_dir}{Output directory for image files}

\item{version}{Version of resulting image
(in the case of multiple tests)}
}
\value{
A data cube.
}
\description{
Takes a set of classified raster layers with probabilities,
             whose metadata is]created by \code{\link[sits]{sits_cube}},
             and applies a Bayesian smoothing function.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # create a ResNet model
    torch_model <- sits_train(samples_modis_ndvi, sits_resnet(epochs = 20))
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "tile", "band", "date")
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = torch_model, output_dir = tempdir()
    )
    # plot the probability cube
    plot(probs_cube)
    # smooth the probability cube using Bayesian statistics
    bayes_cube <- sits_smooth(probs_cube, output_dir = tempdir())
    # plot the smoothed cube
    plot(bayes_cube)
    # label the probability cube
    label_cube <- sits_label_classification(
        bayes_cube, output_dir = tempdir()
    )
    # plot the labelled cube
    plot(label_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
