% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel-draws.R
\name{simulate_parallel}
\alias{simulate_parallel}
\title{Simulate from a model in parallel.}
\usage{
simulate_parallel(model_ref, nsim, index, seeds, socket_names, libraries,
  save_locally = TRUE)
}
\arguments{
\item{model_ref}{object of class \code{\linkS4class{ModelRef}}}

\item{nsim}{number of simulations to be conducted on each chunk.  Vector of
same length as \code{index}}

\item{index}{a vector of positive integer indices.  Allows simulations to be
carried out in chunks.  Each chunk gets a separate RNG stream,
meaning that the results will be identical whether we run these in
parallel or sequentially.}

\item{seeds}{a list of \code{length(index)} L'Ecuyer-CMRG seed vectors.
Each should be from a separate stream.  In particular, starting from
the seed used to generate the model object, seeds[i] should be the
result of calling \code{\link[parallel]{nextRNGStream}} index[i]
times.}

\item{socket_names}{(quoting from \code{\link[parallel]{makePSOCKcluster}}
"either a character vector of host names on which to run the worker
copies of R, or a positive integer (in which case that number of
copies is run on localhost)."}

\item{libraries}{character vector of R packages that will be needed on the
slaves.}

\item{save_locally}{if TRUE, then files will be saved on slaves.  If FALSE,
they will be saved on master.}
}
\description{
This is an internal function. Draws are done in chunks labeled
by indices and of size determined by nsim. Users should call the wrapper
function \code{\link{simulate_from_model}}.
}

