% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gts.R
\name{gen_gts}
\alias{gen_gts}
\title{Simulate a simts TS object using a theoretical model}
\usage{
gen_gts(n, model, start = 0, end = NULL, freq = 1, unit_ts = NULL,
  unit_time = NULL, name_ts = NULL, name_time = NULL)
}
\arguments{
\item{n}{An \code{integer} containing the length of the time series.}

\item{model}{A \code{ts.model} or \code{simts} object containing the available models in the simts package.}

\item{start}{A \code{numeric} that provides the time of the first observation.}

\item{end}{A \code{numeric} that provides the time of the last observation.}

\item{freq}{A \code{numeric} that provides the rate of samples. Default value is 1.}

\item{unit_ts}{A \code{string} that contains the unit expression of the time series. Default value is \code{NULL}.}

\item{unit_time}{A \code{string} that contains the unit expression of the time. Default value is \code{NULL}.}

\item{name_ts}{A \code{string} that provides an identifier for the time series data. Default value is \code{NULL}.}

\item{name_time}{A \code{string} that provides an identifier for the time. Default value is \code{NULL}.}
}
\value{
A \code{gts} object
}
\description{
Create a \code{gts} object based on a time series model.
}
\details{
This function accepts either a \code{ts.model} object (e.g. AR1(phi = .3, sigma2 =1) + WN(sigma2 = 1)) or a \code{simts} object.
}
\examples{
# Set seed for reproducibility
set.seed(1336)
n = 1000

# AR1 + WN
model = AR1(phi = .5, sigma2 = .1) + WN(sigma2=1)
x = gen_gts(n, model)
plot(x)

# Reset seed
set.seed(1336)

# GM + WN
# Convert from AR1 to GM values
m = ar1_to_gm(c(.5,.1),10)

# Beta = 6.9314718, Sigma2_gm = 0.1333333
model = GM(beta = m[1], sigma2_gm = m[2]) + WN(sigma2=1)
x2 = gen_gts(n, model, freq = 10, unit_time = 'sec')
plot(x2)

# Same time series
all.equal(x, x2, check.attributes = FALSE)
}
\author{
James Balamuta and Wenchao Yang
}
