% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_data_by_event.R
\name{cut_data_by_event}
\alias{cut_data_by_event}
\title{Cut a dataset for analysis at a specified event count}
\usage{
cut_data_by_event(x, event)
}
\arguments{
\item{x}{A time-to-event dataset, for example, generated by \code{\link[=sim_pw_surv]{sim_pw_surv()}}.}

\item{event}{Event count at which data cutoff is to be made.}
}
\value{
A data frame ready for survival analysis, including columns time to
event (\code{tte}), \code{event}, the \code{stratum}, and the \code{treatment}. The class of
the data frame is \code{tte_data}, and the attribute \code{ratio} generated by
\code{\link[=sim_pw_surv]{sim_pw_surv()}} is also attached.
}
\description{
Takes a time-to-event data set and cuts the data at which an
event count is reached.
}
\examples{
# Use default enrollment and event rates at cut at 100 events
x <- sim_pw_surv(n = 200) |> cut_data_by_event(100)
table(x$event, x$treatment)
}
