% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{survParamPlot}
\alias{survParamPlot}
\title{Plot survival curves}
\usage{
survParamPlot(formula, shape, points = NULL, n = 100, scale = 1, limits = NULL)
}
\arguments{
\item{formula}{This is the "formula" parameter of the Weibull-based survival curve
that can be used to define the scale of the distribution.}

\item{shape}{The parameter that defines the shape of the distribution.}

\item{points}{An optional list of two-element vectors specifying the desired 
time and probability pairs that define the desired survival curve. If no list
is specified then the plot will not include any points.}

\item{n}{The number of points along the curve that will be used to 
define the line. Defaults to 100.}

\item{scale}{An optional scale parameter that defaults to 1. If the value is 
1, the scale of the distribution is determined entirely by the argument "f".}

\item{limits}{A vector of length 2 that specifies x-axis limits for the plot. 
The default is NULL, in which case no limits are imposed.}
}
\value{
A ggplot of the survival curve defined by the specified parameters.
If the argument points is specified, the plot will include them
}
\description{
Plot survival curves
}
\examples{
points <- list(c(60, 0.90), c(100, .75), c(200, .25), c(250, .10))
r <- survGetParams(points)
survParamPlot(r[1], r[2])
survParamPlot(r[1], r[2], points = points)
survParamPlot(r[1], r[2], points = points, limits = c(0, 100))
}
\concept{utility}
