% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_tile.R
\name{gg_tile_col}
\alias{gg_tile_col}
\title{Tile ggplot that is coloured.}
\usage{
gg_tile_col(
  data,
  x_var,
  y_var,
  col_var,
  label_var = NULL,
  text_var = NULL,
  pal = NULL,
  pal_label = "#323232",
  pal_na = "#7F7F7F",
  pal_rev = FALSE,
  alpha_fill = 1,
  alpha_line = 1,
  size_line = 0.5,
  size_label = 3.5,
  size_height = 1,
  width = 1,
  title = NULL,
  title_wrap = 75,
  subtitle = NULL,
  subtitle_wrap = 75,
  x_expand = c(0, 0),
  x_labels = snakecase::to_sentence_case,
  x_na_rm = FALSE,
  x_rev = FALSE,
  x_title = NULL,
  x_title_wrap = 50,
  y_expand = c(0, 0),
  y_labels = snakecase::to_sentence_case,
  y_na_rm = FALSE,
  y_rev = FALSE,
  y_title = NULL,
  y_title_wrap = 50,
  col_cuts = NULL,
  col_intervals_left = TRUE,
  col_labels = NULL,
  col_legend_none = FALSE,
  col_method = NULL,
  col_na_rm = FALSE,
  col_breaks_n = 4,
  col_title = NULL,
  col_title_wrap = 25,
  caption = NULL,
  caption_wrap = 75,
  theme = gg_theme(),
  mobile = FALSE
)
}
\arguments{
\item{data}{A data frame in a structure to be plotted untransformed. Required input.}

\item{x_var}{Unquoted variable to be on the x scale (i.e. character, factor, logical, numeric, date or datetime). If numeric, date or datetime, variable values are bins that are mutually exclusive and equidistant. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y scale. Required input.}

\item{col_var}{Unquoted categorical variable to colour the tiles Required input.}

\item{label_var}{Unquoted variable to label the tiles.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{pal}{Character vector of hex codes.}

\item{pal_label}{Hex code for the label font colour. Defaults to "#323232".}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{alpha_fill}{The opacity of the fill. Defaults to 1.}

\item{alpha_line}{The opacity of the outline. Defaults to 1.}

\item{size_line}{The size of the outlines of bars.}

\item{size_label}{The size of the of labels. Defaults to 3.5.}

\item{size_height}{Height of tiles. Defaults to 1.}

\item{width}{Width of tiles. Defaults to 1.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 60.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 60.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. If NULL, categorical variable labels are converted to sentence case. Use function(x) x to keep labels untransformed.}

\item{x_na_rm}{TRUE or FALSE of whether to include x_var NA values. Defaults to FALSE.}

\item{x_rev}{TRUE or FALSE of whether the x variable variable is reversed. Defaults to FALSE.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. If NULL, categorical variable labels are converted to sentence case. Use function(x) x to keep labels untransformed.}

\item{y_na_rm}{TRUE or FALSE of whether to include y_var NA values. Defaults to FALSE.}

\item{y_rev}{TRUE or FALSE of whether the y variable variable is reversed. Defaults to FALSE.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_intervals_left}{For a numeric colour variable, TRUE or FALSE of whether bins or quantiles are to be cut left-closed. Defaults to TRUE.}

\item{col_labels}{A function or named vector to modify colour scale labels. Defaults to snakecase::to_sentence_case for categorical colour variables and scales::label_comma() for numeric. Use function(x) x to keep labels untransformed.}

\item{col_legend_none}{TRUE or FALSE of whether to remove the legend.}

\item{col_method}{The method of colouring features, either "bin", "quantile", "continuous", or "category." If numeric, defaults to "bin".}

\item{col_na_rm}{TRUE or FALSE of whether to include col_var NA values. Defaults to FALSE.}

\item{col_breaks_n}{For a numeric colour variable, the desired number of intervals on the colour scale.}

\item{col_title}{Colour title string for the legend. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where mobile equals TRUE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 75.}

\item{theme}{A ggplot2 theme.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
Tile ggplot that is coloured, but not facetted.
}
\examples{
library(simplevis)
library(dplyr)
library(palmerpenguins)

plot_data <- penguins \%>\% 
  group_by(species, sex) \%>\% 
  summarise(bill_length_mm = round(mean(bill_length_mm, na.rm = TRUE), 1)) 
  
gg_tile_col(plot_data, 
  x_var = sex, 
  y_var = species, 
  col_var = bill_length_mm, 
  label_var = bill_length_mm) 
            
}
