% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_format.R
\name{cut_format}
\alias{cut_format}
\title{Convert Numeric to Factor, with custom formatting}
\usage{
cut_format(
  x,
  breaks,
  include.lowest = FALSE,
  right = TRUE,
  ordered_result = FALSE,
  ...,
  format_fun = format,
  sep = ", ",
  paren = c("(", "[", ")", "]")
)
}
\arguments{
\item{x}{a numeric vector which is to be converted to a factor by cutting.}

\item{breaks}{`[numeric]`\cr
A vector of two or more unique cut points}

\item{include.lowest}{logical, indicating if an \sQuote{x[i]} equal to
    the lowest (or highest, for \code{right = FALSE}) \sQuote{breaks}
    value should be included.}

\item{right}{logical, indicating if the intervals should be closed on
    the right (and open on the left) or vice versa.}

\item{ordered_result}{logical: should the result be an ordered factor?}

\item{...}{Passed to `cut()`}

\item{format_fun}{`[function(x): character]`\cr
A vectorized function that performs the desired formatting.  Default:
[base::format()]}

\item{sep}{`[character(1)]`\cr
The separator between lower and upper end of the interval. Default:
`", "`}

\item{paren}{`[character(4)]`\cr
Opening and closing parentheses in two variants. Default:
\code{c("(", "[", ")", "]")}}
}
\description{
This is an enhanced version of [base::cut()] that allows a custom
formatting to be applied to the values.
}
\examples{
library(simplevis)
library(palmerpenguins)
library(dplyr)

penguins \%>\%
  select(flipper_length_mm) \%>\%
  mutate(
    flipper_length_mm2 = simplevis:::cut_format(
      flipper_length_mm,
      c(0, 150, 175, 200, Inf),
      right = TRUE,
      include.lowest = TRUE,
      dig.lab = 50,
      ordered_result = TRUE
    )
  ) \%>\%
  mutate(
    flipper_length_mm3 = simplevis:::cut_format(
      flipper_length_mm,
      c(0, 150, 175, 200, Inf),
      right = TRUE,
      include.lowest = TRUE,
      dig.lab = 50,
      ordered_result = TRUE,
      format_fun = scales::label_dollar(accuracy = 0.1)
    )
  )
}
\references{
kimisc package https://github.com/krlmlr/kimisc
}
\keyword{internal}
