% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaf_sf.R
\name{leaf_sf_col}
\alias{leaf_sf_col}
\title{Simple feature leaflet map that is coloured.}
\usage{
leaf_sf_col(
  data,
  col_var,
  label_var = NULL,
  popup = TRUE,
  popup_vars_vctr = NULL,
  popup_numeric_format = function(x) prettyNum(x, big.mark = "", scientific = FALSE),
  popup_vars_rename = snakecase::to_sentence_case,
  pal = NULL,
  pal_na = "#7F7F7F",
  pal_rev = FALSE,
  alpha_point = NULL,
  alpha_line = NULL,
  alpha_fill = NULL,
  size_point = 2,
  size_line = 2,
  basemap = "light",
  col_breaks_n = 4,
  col_cuts = NULL,
  col_intervals_right = TRUE,
  col_labels = NULL,
  col_legend_none = FALSE,
  col_method = NULL,
  col_na_rm = FALSE,
  col_title = NULL,
  label_numeric_format = function(x) prettyNum(x, big.mark = ",", scientific = FALSE),
  layer_id_var = NULL,
  map_id = "map"
)
}
\arguments{
\item{data}{An sf object of geometry type point/multipoint, linestring/multilinestring or polygon/multipolygon geometry type. Required input.}

\item{col_var}{Unquoted variable to colour the features by. Required input.}

\item{label_var}{Unquoted variable to label the features by. If NULL, defaults to using the colour variable.}

\item{popup}{TRUE or FALSE of whether to have a popup.}

\item{popup_vars_vctr}{Vector of quoted variable names to include in the popup. If NULL, defaults to making a leafpop::popupTable of all columns.}

\item{popup_numeric_format}{A function to format all numeric variables within the popup column. Defaults to non-scientific. Use function(x) x to leave as is.}

\item{popup_vars_rename}{Function to rename column names for the popup. Defaults to snakecase::to_sentence_case. Use function(x) x to leave column names untransformed.}

\item{pal}{Character vector of hex codes.}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{alpha_point}{The opacity of the points.}

\item{alpha_line}{The opacity of the outline.}

\item{alpha_fill}{The opacity of the fill.}

\item{size_point}{Size of points (i.e. radius). Defaults to 2.}

\item{size_line}{Size of lines around features (i.e. weight). Defaults to 2.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{col_breaks_n}{For a numeric colour variable, the desired number of intervals on the colour scale.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_intervals_right}{For a numeric colour variable, TRUE or FALSE of whether bins or quantiles are to be cut right-closed. Defaults to TRUE.}

\item{col_labels}{A function or named vector to modify the colour scale labels. Defaults to snakecase::to_sentence_case if categorical, and scales::label_comma() if numeric. Use function(x) x to keep labels untransformed.}

\item{col_legend_none}{TRUE or FALSE of whether to remove the legend.}

\item{col_method}{The method of colouring features, either "bin", "quantile", "continuous", or "category." If numeric, defaults to "bin".}

\item{col_na_rm}{TRUE or FALSE of whether to include col_var NA values. Defaults to FALSE.}

\item{col_title}{A title string that will be wrapped into the legend.}

\item{label_numeric_format}{A function to format the numeric labels. Defaults to adding a comma seperator. Use function(x) x to leave as is.}

\item{layer_id_var}{Unquoted variable to be used as a shiny id, such that in the event where a feature is clicked on, the applicable value of this is available as input$map_marker_click$id or input$map_shape_click$id.}

\item{map_id}{The shiny map id for a leaflet map within a shiny app. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of simple features in leaflet that is coloured.
}
\examples{
leaf_sf_col(example_point,
              col_var = trend_category)

leaf_sf_col(example_polygon,
              col_var = density)

leaf_sf_col(example_polygon,
              col_var = density,
              col_method = "bin",
              col_breaks_n = 5)

leaf_sf_col(example_polygon,
              col_var = density,
              col_method = "bin",
              col_cuts = c(0, 10, 50, 100, 150, 200, Inf))

leaf_sf_col(example_polygon,
              col_var = density,
              col_method = "quantile",
              col_breaks_n = 4)

leaf_sf_col(example_polygon,
              col_var = density,
              col_method = "quantile",
              col_cuts = c(0, 0.25, 0.5, 0.75, 0.95, 1))

}
