% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numeric_breaks.R
\name{sv_numeric_breaks_h}
\alias{sv_numeric_breaks_h}
\title{Calculate the breaks for a horizontal axis numeric vector.}
\usage{
sv_numeric_breaks_h(var_vctr, balance = FALSE, pretty_n = 6,
  trans = "identity", zero = TRUE, mobile = FALSE)
}
\arguments{
\item{var_vctr}{A numeric vector for the horizontal scale from which to determine breaks from.}

\item{balance}{Add balance to the y axis so that zero is in the centre of the horizontal scale.}

\item{pretty_n}{The desired number of intervals on the horizontal axis, as calculated by the pretty algorithm. Defaults to 6.}

\item{trans}{A string specifying a transformation for the horizontal axis scale, such as "log10" or "sqrt". Defaults to "identity".}

\item{zero}{TRUE or FALSE of whether the minimum of the horizontal scale is zero. Defaults to TRUE.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A vector of breaks
}
\description{
Calculate the breaks for a horizontal axis numeric vector.
}
\keyword{internal}
