% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_stars_fun.R
\name{ggplot_stars}
\alias{ggplot_stars}
\title{Map of an array in ggplot.}
\usage{
ggplot_stars(data, pal = NULL, coastline = NULL,
  coastline_behind = FALSE, coastline_pal = "black",
  title = "[Title]", subtitle = NULL, caption = "",
  font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, wrap_title = 70, wrap_subtitle = 80,
  wrap_caption = 80, isMobile = FALSE)
}
\arguments{
\item{data}{A stars object with 2 dimensions x and y. Required input.}

\item{pal}{Character vector of hex codes, or provided objects with pal_ prefixes.}

\item{coastline}{Add a sf object as a coastline (or administrative boundaries). Defaults to NULL. Use nz (or nz_region) to add a new zealand coastline. Or add a custom sf object.}

\item{coastline_behind}{TRUE or FALSE as to whether the coastline is to be behind the stars object defined in the data argument. Defaults to FALSE.}

\item{coastline_pal}{Colour of the coastline. Defaults to "#7F7F7F".}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. In a shinyapp, isMobile should be specified as input$isMobile. TRUEhis enable mobile compatible apps, where apps have ui mobileDetect function defined and mobile.js file in www/js/ folder  https://g3rv4.com/2017/08/shiny-detect-mobile-browsers}
}
\value{
A ggplot object.
}
\description{
Map of an array in ggplot that is not coloured and not facetted.
}
\examples{
ggplot_stars(data = example_stars_nz_no3n, coastline = nz)
}
