% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/si_model.R
\name{si_calculate}
\alias{si_calculate}
\title{Calculate flow using a pre-existing function}
\usage{
si_calculate(
  od,
  fun,
  constraint_production,
  constraint_attraction,
  constraint_total,
  output_col = "interaction",
  ...
)
}
\arguments{
\item{od}{A data frame representing origin-destination data, e.g. as created by
\code{\link[=si_to_od]{si_to_od()}}}

\item{fun}{A function that calculates the interaction (e.g. the number of trips)
between each OD pair}

\item{constraint_production}{Character representing column in \code{od}.
This argument, when set, ensures that the outputs are 'production constrained':
the total 'interaction' (e.g. n. trips) for all OD pairs is set such that
the total for each zone of origin cannot go above this value.}

\item{constraint_attraction}{Character representing column in \code{od}.
This argument, when set, ensures that the outputs are 'attraction constrained':
the total 'interaction' (e.g. n. trips) for all OD pairs is set such that
the sum of trips to destination is equal to the mean value per destination.}

\item{constraint_total}{Single number representing the total interaction.
This argument, when set, ensures that the sum of the interaction
calculated will equal the value given.}

\item{output_col}{Character string containing the name of the new output
column. \code{"interaction"} by default.}

\item{...}{Arguments passed to \code{fun}}
}
\value{
An sf data frame
}
\description{
Executes a spatial interaction model based on an OD data frame
and user-specified function
}
\examples{
od = si_to_od(si_zones, si_zones, max_dist = 4000)
fun_dd = function(d = "distance_euclidean", beta = 0.3) exp(-beta * d / 1000)
fun_dd(d = (1:5)*1000)
od_dd = si_calculate(od, fun = fun_dd, d = distance_euclidean)
plot(od$distance_euclidean, od_dd$interaction)
fun = function(O, n, d, beta) O * n * exp(-beta * d / 1000)
od_output = si_calculate(od, fun = fun, beta = 0.3, O = origin_all, 
  n = destination_all, d = distance_euclidean)
head(od_output)
plot(od$distance_euclidean, od_output$interaction)
od_pconst = si_calculate(od, fun = fun, beta = 0.3, O = origin_all,
  n = destination_all, d = distance_euclidean, constraint_production = origin_all)
plot(od_pconst$distance_euclidean, od_pconst$interaction)
plot(od_pconst["interaction"], logz = TRUE)
od_dd = si_calculate(od, fun = fun_dd, d = distance_euclidean, output_col = "res")
head(od_dd$res)
od_dd = si_calculate(od, fun = fun_dd, d = distance_euclidean, constraint_total = 10)
sum(od_dd$interaction)
}
