% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{batch}
\alias{batch}
\alias{separate}
\title{Batch/Separate Arrivals}
\usage{
batch(.trj, n, timeout = 0, permanent = FALSE, name = "", rule = NULL)

separate(.trj)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{n}{batch size, accepts a numeric or a callable object (a function)
which must return a numeric.}

\item{timeout}{set an optional timer which triggers batches every
\code{timeout} time units even if the batch size has not been fulfilled,
accepts a numeric or a callable object (a function) which must return a
numeric (0 = disabled).}

\item{permanent}{if \code{TRUE}, batches cannot be split.}

\item{name}{optional string. Unnamed batches from different \code{batch}
activities are independent. However, if you want to feed arrivals from
different trajectories into a same batch, you need to specify a common name
across all your \code{batch} activities.}

\item{rule}{an optional callable object (a function) which will be applied to
every arrival to determine whether it should be included into the batch, thus
it must return a boolean.}
}
\value{
Returns the trajectory object.
}
\description{
Activities for collecting a number of arrivals before they can continue processing
and splitting a previously established batch.
}
\examples{
## unnamed batch with a timeout
traj <- trajectory() \%>\%
  log_("arrived") \%>\%
  batch(2, timeout=5) \%>\%
  log_("in a batch") \%>\%
  timeout(5) \%>\%
  separate() \%>\%
  log_("leaving")

simmer() \%>\%
  add_generator("dummy", traj, at(0:2)) \%>\%
  run() \%>\% invisible

## batching based on some dynamic rule
traj <- trajectory() \%>\%
  log_("arrived") \%>\%
  # always FALSE -> no batches
  batch(2, rule=function() FALSE) \%>\%
  log_("not in a batch") \%>\%
  timeout(5) \%>\%
  separate() \%>\%
  log_("leaving")

simmer() \%>\%
  add_generator("dummy", traj, at(0:2)) \%>\%
  run() \%>\% invisible

## named batch, shared across trajectories
traj0 <- trajectory() \%>\%
  log_("arrived traj0") \%>\%
  batch(2, name = "mybatch")

traj1 <- trajectory() \%>\%
  log_("arrived traj1") \%>\%
  timeout(1) \%>\%
  batch(2, name = "mybatch") \%>\%
  log_("in a batch") \%>\%
  timeout(2) \%>\%
  separate() \%>\%
  log_("leaving traj1")

simmer() \%>\%
  add_generator("dummy0", traj0, at(0)) \%>\%
  add_generator("dummy1", traj1, at(0)) \%>\%
  run() \%>\% invisible

}
