% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_eff_sim.r
\name{sim_rand_eff}
\alias{sim_rand_eff}
\title{Function to simulate random effects.}
\usage{
sim_rand_eff(
  random_var,
  n,
  rand_gen,
  ther = c(0, 1),
  ther_sim = FALSE,
  cor_vars = NULL,
  ...
)
}
\arguments{
\item{random_var}{Variance of random effects. Must be same length as random.}

\item{n}{Cluster sample size.}

\item{rand_gen}{The generating function used (e.g. rnorm).}

\item{ther}{A vector of length two that specifies the theoretical mean and
standard deviation of the rand_gen. This would commonly be used
to standardize the generating variable to have a mean of 0 and
standard deviation of 1 to meet model assumptions. The variable
is then rescaled to have the variance specified by random_var.}

\item{ther_sim}{A TRUE/FALSE flag indicating whether the error simulation 
function should be simulated, that is should the mean and standard deviation
used for standardization be simulated.}

\item{cor_vars}{A vector of correlations between random effects.}

\item{...}{Additional values that need to be passed to the function
called from rand_gen.}
}
\description{
Input simulation parameters and returns random effects.
}
\details{
Simulates random effects for the master function \code{\link{sim_reg}} when
simulating a linear mixed model, both cross sectional and longitudinal. 
Allows the ability to simulate random effects from a Laplace, 
chi-square (1), mixture normal, or normal distribution.
}
