% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_reg.r
\name{sim_glm}
\alias{sim_glm}
\title{Master generalized simulation function.}
\usage{
sim_glm(fixed, random, random3, fixed_param, random_param = list(),
  random_param3 = list(), cov_param, k, n, p, data_str, cor_vars = NULL,
  fact_vars = list(NULL), unbal = list(level2 = FALSE, level3 = FALSE),
  unbal_design = list(level2 = NULL, level3 = NULL), contrasts = NULL,
  outcome_type, ...)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation.
To suppress intercept add -1 to formula.}

\item{random}{One sided formula for random effects in the simulation. 
Must be a subset of fixed.}

\item{random3}{One sided formula for random effects at third level in the 
simulation. Must be a subset of fixed (and likely of random).}

\item{fixed_param}{Fixed effect parameter values (i.e. beta weights).
Must be same length as fixed.}

\item{random_param}{A list of named elements that must contain: 
\itemize{
   \item  random_var = variance of random parameters,
   \item  rand_gen = Name of simulation function for random effects.
}
       Optional elements are:
\itemize{
   \item ther: Theorectial mean and variance from rand_gen,
   \item ther_sim: Simulate mean/variance for standardization purposes,
   \item cor_vars: Correlation between random effects,
   \item ...: Additional parameters needed for rand_gen function.
 }}

\item{random_param3}{A list of named elements that must contain: 
\itemize{
    \item random_var = variance of random parameters,
    \item rand_gen = Name of simulation function for random effects.
}
      Optional elements are:
\itemize{
    \item ther: Theorectial mean and variance from rand_gen,
    \item ther_sim: Simulate mean/variance for standardization purposes,
    \item cor_vars: Correlation between random effects,
    \item ...: Additional parameters needed for rand_gen function.
}}

\item{cov_param}{List of arguments to pass to the continuous generating 
function, must be the same order as the variables specified in fixed. 
This list does not include intercept, time, factors, or 
interactions. Required arguments include:
\itemize{
  \item dist_fun: This is a quoted R distribution function.
  \item var_type: This is the level of variable to generate. Must be 
    either 'single', 'level1', 'level2', or 'level3'. 
    Must be same order as fixed formula above.
}
Optional arguments to the distribution functions are in a nested list,
 see the examples or vignettes for example code.}

\item{k}{Number of third level clusters.}

\item{n}{Cluster sample size.}

\item{p}{Within cluster sample size.}

\item{data_str}{Type of data. Must be "cross", "long", or "single".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels = Number of levels for ordinal or factor variables.
     \item var_type = Must be 'single', 'level1', 'level2', or 'level3'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{unbal}{A named TRUE/FALSE list specifying whether unbalanced simulation 
design is desired. The named elements must be: "level2" or "level3" representing
unbalanced simulation for level two and three respectively. Default is FALSE,
indicating balanced sample sizes at both levels.}

\item{unbal_design}{When unbal = TRUE, this specifies the design for unbalanced
simulation in one of two ways. It can represent the minimum and maximum 
sample size within a cluster via a named list. This will be drawn from a 
random uniform distribution with min and max specified. 
Secondly, the actual sample sizes within each cluster
can be specified. This takes the form of a vector that must have the same length 
as the level two or three sample size. These are specified as a named list in which
level two sample size is controlled via "level2" and level three sample size is 
controlled via "level3".}

\item{contrasts}{An optional list that specifies the contrasts to be used 
for factor variables (i.e. those variables with .f or .c). 
See \code{\link{contrasts}} for more detail.}

\item{outcome_type}{A vector specifying the type of outcome, must be either
logistic or poisson. Logitstic outcome will be 0/1 and poisson outcome will
be counts.}

\item{...}{Not currently used.}
}
\description{
Takes simulation parameters as inputs and returns simulated data.
}
\details{
Simulated data is useful for classroom demonstrations and to study 
the impacts of assumption violations on parameter estimates, statistical
power, or empirical type I error rates.

This function allows researchers a flexible approach to simulate regression
models, including single level models and cross sectional or longitudinal
linear mixed models (aka. hierarchical linear models or multilevel models).
}
\examples{
# generating parameters for single level regression
set.seed(2)
fixed <- ~1 + act + diff + numCourse + act:numCourse
fixed_param <- c(0.1, -0.2, 0.15, 0.5, -0.02)
cov_param <- list(dist_fun = c('rnorm', 'rnorm', 'rnorm'),
   var_type = c("single", "single", "single"),
   opts = list(list(mean = 0, sd = 4),
   list(mean = 0, sd = 3),
   list(mean = 0, sd = 3)))
n <- 150
temp_single <- sim_glm(fixed = fixed, fixed_param = fixed_param, 
  cov_param = cov_param, n = n, data_str = "single", outcome_type = 'logistic')
  
  # counts
temp_single <- sim_glm(fixed = fixed, fixed_param = fixed_param, 
  cov_param = cov_param, n = n, data_str = "single", outcome_type = 'poisson')

# Longitudinal linear mixed model example
fixed <- ~1 + time + diff + act + time:act
random <- ~1 + time + diff
fixed_param <- c(0.1, -0.2, 0.15, 0.5, -0.02)
random_param <- list(random_var = c(7, 4, 2), rand_gen = 'rnorm')
cov_param <- list(dist_fun = c('rnorm', 'rnorm'),
   var_type = c("level1", "level2"),
   opts = list(list(mean = 0, sd = 1.5),
   list(mean = 0, sd = 4)))
n <- 150
p <- 30
data_str <- "long"
temp_long <- sim_glm(fixed, random, random3 = NULL, fixed_param, 
random_param, random_param3 = NULL,
 cov_param, k = NULL, n, p, data_str = data_str, outcome_type = 'logistic')

 # counts 
temp_long <- sim_glm(fixed, random, random3 = NULL, fixed_param, 
random_param, random_param3 = NULL,
 cov_param, k = NULL, n, p, data_str = data_str, outcome_type = 'poisson')

# Three level example
fixed <- ~1 + time + diff + act + actClust + time:act
random <- ~1 + time + diff
random3 <- ~ 1 + time
fixed_param <- c(0.1, -0.2, 0.15, 0.5, -0.02, 0.03)
random_param <- list(random_var = c(7, 4, 2), rand_gen = 'rnorm')
random_param3 <- list(random_var = c(4, 2), rand_gen = 'rnorm')
cov_param <- list(dist_fun = c('rnorm', 'rnorm', 'rnorm'), 
   var_type = c("level1", "level2", "level3"),
   opts = list(list(mean = 0, sd = 1.5),
   list(mean = 0, sd = 4),
   list(mean = 0, sd = 2)))
k <- 10
n <- 15
p <- 10
data_str <- "long"
temp_three <- sim_glm(fixed, random, random3, fixed_param, random_param, 
  random_param3, cov_param, k,n, p, data_str = data_str, outcome_type = 'logistic')
  
  # count data sim
  temp_three <- sim_glm(fixed, random, random3, fixed_param, random_param, 
  random_param3, cov_param, k,n, p, data_str = data_str, outcome_type = 'poisson')


}
