% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Reproduces.r
\name{reproduces}
\alias{reproduces}
\title{Reproduction}
\usage{
reproduces(SP, ncpus = 0, verbose = TRUE)
}
\arguments{
\item{SP}{a list of all simulation parameters.}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns a list containing
\describe{
\item{$reprod$pop.gen}{the generations of simulated population.}
\item{$reprod$reprod.way}{reproduction method, it consists of 'clone', 'dh', 'selfpol', 'randmate', 'randexself', '2waycro', '3waycro', '4waycro', 'backcro', and 'userped'.}
\item{$reprod$sex.rate}{the male rate in the population.}
\item{$reprod$prog}{the progeny number of an individual.}
\item{$geno}{a list of genotype simulation parameters.}
\item{$pheno}{a list of phenotype simulation parameters.}
}
}
\description{
Population reproduction by different mate design.
}
\details{
Build date: Nov 14, 2018
Last update: Apr 29, 2022
}
\examples{
# Generate annotation simulation parameters
SP <- param.annot(qtn.num = list(tr1 = 10))
# Generate genotype simulation parameters
SP <- param.geno(SP = SP, pop.marker = 1e4, pop.ind = 1e2)
# Generate phenotype simulation parameters
SP <- param.pheno(SP = SP, pop.ind = 100)
# Generate selection parameters
SP <- param.sel(SP = SP, sel.single = "comb")
# Generate reproduction parameters
SP <- param.reprod(SP = SP, reprod.way = "randmate")

# Run annotation simulation
SP <- annotation(SP)
# Run genotype simulation
SP <- genotype(SP)
# Run phenotype simulation
SP <- phenotype(SP)
# Run selection
SP <- selects(SP)
# Run reproduction
SP <- reproduces(SP)
}
\author{
Dong Yin
}
