% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep_plot.R
\name{plot_sim_example}
\alias{plot_sim_example}
\title{Plot simulation example.}
\usage{
plot_sim_example(
  substract_ae_per_pat = 0,
  size_dots = 10,
  size_raster_label = 12,
  color_site_a = "#BDBDBD",
  color_site_b = "#757575",
  color_site_c = "gold3",
  color_high = "#00695C",
  color_low = "#25A69A",
  title = TRUE,
  legend = TRUE,
  seed = 5
)
}
\arguments{
\item{substract_ae_per_pat}{integer, subtract aes from patients at site C, Default: 0}

\item{size_dots}{integer, Default: 10}

\item{size_raster_label}{integer, Default: 12}

\item{color_site_a}{character, hex color value, Default: '#BDBDBD'}

\item{color_site_b}{character, hex color value, Default: '#757575'}

\item{color_site_c}{character, hex color value, Default: 'gold3'}

\item{color_high}{character, hex color value, Default: '#00695C'}

\item{color_low}{character, hex color value, Default: '#25A69A'}

\item{title}{logical, include title, Default: T}

\item{legend}{logical, include legend, Default: T}

\item{seed}{pass seed for simulations Default: 5}
}
\value{
ggplot
}
\description{
This plots supplements the package documentation.
}
\details{
uses \code{\link[=plot_dots]{plot_dots()}} and adds 2 simulation panels, uses made-up
site config with three sites A,B,C simulating site C
}
\examples{
\donttest{
plot_sim_example(size_dots = 5)
}
}
\seealso{
\code{\link[cowplot]{get_legend}},\code{\link[cowplot]{plot_grid}}
}
