% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTargetCov.R
\name{simTargetCov}
\alias{simTargetCov}
\title{Data Transformation or Simulation with Target Empirical Covariance Matrix}
\usage{
simTargetCov(X = NULL, n, p, target)
}
\arguments{
\item{X}{Data matrix for transformation.}

\item{n}{Number of observations for data matrix output.}

\item{p}{Number of variables for data matrix output.}

\item{target}{Target empirical covariance for data matrix output.}
}
\description{
\code{simTargetCov} transforms or simulates data with a target empirical covariance matrix supplied by the user.
}
\examples{
# Function to create target covariance matrix with kernel set to r
target_cor <- function(r, p){
  Gamma <- diag(p)
  for(i in 1:(p-1)){
    for(j in (i+1):p){
      Gamma[i,j] <- Gamma[j,i] <- r^(abs(i-j))
    }
  }
  return(Gamma)
}

# Transformation of data to target empirical covariance
dat.target.cov <- simTargetCov(X = MASS::mvrnorm(30, mu = rep(0,6),
                               Sigma = target_cor(0.5,6)),
                               target = target_cor(0.5,6))
round(cov(dat.target.cov), 2)

# Simulation of data with target empirical covariance
sim.target.cov <- simTargetCov(n = 30, p = 6, target = target_cor(0.5,6))
round(cov(sim.target.cov), 2)

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
