% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-list-2-matrix.R
\name{Sim2Matrix}
\alias{Sim2Matrix}
\title{Simulation Output to Matrix}
\usage{
Sim2Matrix(x, eta = FALSE)
}
\arguments{
\item{x}{R object.
Output of
\code{\link[=SimSSM0]{SimSSM0()}},
\code{\link[=SimSSMOU]{SimSSMOU()}},
\code{\link[=SimSSMVAR]{SimSSMVAR()}},
\code{\link[=SimSSM0Fixed]{SimSSM0Fixed()}},
\code{\link[=SimSSMOUFixed]{SimSSMOUFixed()}}, or
\code{\link[=SimSSMVARFixed]{SimSSMVARFixed()}}.}

\item{eta}{Logical.
If \code{eta = TRUE}, include \code{eta}.
If \code{eta = FALSE}, exclude \code{eta}.}
}
\value{
Returns a matrix of simulated data.
}
\description{
This function converts the output of
\code{\link[=SimSSM0]{SimSSM0()}},
\code{\link[=SimSSMOU]{SimSSMOU()}},
\code{\link[=SimSSMVAR]{SimSSMVAR()}},
\code{\link[=SimSSM0Fixed]{SimSSM0Fixed()}},
\code{\link[=SimSSMOUFixed]{SimSSMOUFixed()}}, or
\code{\link[=SimSSMVARFixed]{SimSSMVARFixed()}}
to a matrix.
}
\examples{
# prepare parameters
set.seed(42)
k <- p <- 3
I <- diag(k)
I_sqrt <- chol(I)
null_vec <- rep(x = 0, times = k)
n <- 5
mu0 <- null_vec
sigma0_sqrt <- I_sqrt
alpha <- null_vec
beta <- diag(x = 0.50, nrow = k)
psi_sqrt <- I_sqrt
nu <- null_vec
lambda <- I
theta_sqrt <- chol(diag(x = 0.50, nrow = k))
time <- 50
burn_in <- 0

# generate data
ssm <- SimSSM0(
  mu0 = mu0,
  sigma0_sqrt = sigma0_sqrt,
  alpha = alpha,
  beta = beta,
  psi_sqrt = psi_sqrt,
  nu = nu,
  lambda = lambda,
  theta_sqrt = theta_sqrt,
  time = time,
  burn_in = burn_in
)

# list to matrix
mat <- Sim2Matrix(ssm)
str(mat)
head(mat)

# generate data
ssm <- SimSSM0Fixed(
  n = n,
  mu0 = mu0,
  sigma0_sqrt = sigma0_sqrt,
  alpha = alpha,
  beta = beta,
  psi_sqrt = psi_sqrt,
  nu = nu,
  lambda = lambda,
  theta_sqrt = theta_sqrt,
  time = time,
  burn_in = burn_in
)

# list to matrix
mat <- Sim2Matrix(ssm)
str(mat)
head(mat)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{OU2SSM}()},
\code{\link{SimSSM0Fixed}()},
\code{\link{SimSSM0Vary}()},
\code{\link{SimSSM0}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUVary}()},
\code{\link{SimSSMOU}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARVary}()},
\code{\link{SimSSMVAR}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{misc}
\keyword{simStateSpace}
