% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.R
\name{mse}
\alias{mse}
\title{Calculate the Mean Squared Error}
\usage{
mse(true_value, estimates, get = c("mse", "mse_mcse"), na.rm = FALSE, ...)
}
\arguments{
\item{true_value}{The true value which is being estimated.}

\item{estimates}{A numeric vector containing the estimates from the model(s).}

\item{get}{A character vector containing the values returned by the function.}

\item{na.rm}{A logical value indicating whether NA values for \code{estimates} should be removed before MSE calculation.}

\item{...}{Additional arguments to be ignored.}
}
\value{
A named vector containing the estimate and the Monte Carlo standard error for the bias.
}
\description{
Calculates the Mean Squared Error of the model estimates from the true value and the Monte Carlo standard error for this estimate.
}
\examples{
mse(true_value=0, estimates=rnorm(100))
}
