% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{generate_data}
\usage{
generate_data(
  n_obs = 100,
  corr = 0.3,
  effect = 0.42,
  ld = c(1, 1, 1, 1),
  alp = 0.9,
  effect_x = 0.4,
  effect_z = 0.2
)
}
\arguments{
\item{n_obs}{Integer. The number of observations.}

\item{corr}{Numeric. The correlation of the latent variables.}

\item{effect}{Numeric. The effect of the moderator.}

\item{ld}{Numeric. The factor loading of the latent variable to its indicators.}

\item{alp}{Numeric. The reliability of the latent variable.}

\item{effect_x}{Numeric. The direct effect of x.}

\item{effect_z}{Numeric. The direct effect of z.}
}
\value{
A dataset simulated from the argument settings.
}
\description{
Generates data based on the simulation settings provided by Cheung et al. (2021).
Note that the reliability used here is omega.
}
\examples{
n_obs = 100
corr = 0.1
effect = 0.12
ld = c(1,1,1,1)
alp = 0.9
generate_data(n_obs, corr, effect, ld, alp)
}
