% Generated by JSDoc (with jsdoc-r template): do not edit by hand
% Please edit documentation in shinylight-toolkit.js
\docType{package}
\name{toolkit.loadFileButton}
\alias{toolkit.loadFileButton}
\title{JavaScript function: Returns a button that uploads a file from the client.}
\arguments{
\item{id}{\code{string} The HTML id of the button will be
\code{'button-' + id}. It is also used in the interpretation of
the \code{translations} argument.}
\item{fn}{\code{function} A binary callback function. Its two
parameters are the File object uploaded and a (nullary)
function that will be called when the operation completes.}
\item{translations}{\code{object} An object with a key \code{id}
having a value that is an object having a key \code{'name'}
with value the display name of the button, and optionally a key
\code{'help'} with value of the tooltip text.}
\item{createFileInput}{\code{function} [optional] A function to create an element that
uploads a file. By default this is a normal \code{<input type="file">}
with an extra \code{show} member function that does nothing.
The function takes two parameters: \code{uploadFn} and \code{doneFn}.
\code{uploadFn} must be called when a file has been chosen for upload;
it takes two parameters: a File object and a callback function that is
called on completion. You should either pass \code{doneFn} as this
second parameter, or a function that performs some actions then
calls \code{doneFn()} itself. The return value of \code{createFileInput}
should be the element itself, monkey-patched to include a \code{show()}
method that will be called when the Load button is clicked.}
}
\value{
The button.
}
\description{
This button is an HTML element, but it is not an HTML button.
Styling and JavaScript provide the button-like look-and-feel.
}