% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinylight.R
\name{rrpcServer}
\alias{rrpcServer}
\title{Makes and starts a server for serving R calculations}
\usage{
rrpcServer(
  interface,
  host = "0.0.0.0",
  port = NULL,
  appDirs = NULL,
  root = "/",
  initialize = NULL
)
}
\arguments{
\item{interface}{List of functions to be served. The names of the elements
are the names that the client will use to call them.}

\item{host}{Interface to listen on (default is \code{'0.0.0.0'}, that
is, all interfaces)}

\item{port}{Port to listen on}

\item{appDirs}{List of directories in which to find static files to serve}

\item{root}{Root of the app on the server (with trailing slash)}

\item{initialize}{A json string or list (that will be converted to a
JSON string) to be passed to the JavaScript as initial data. For
non-framework apps, the index.html must contain a line containing
\code{var shinylight_initial_data=}, which will be replaced with
code that sets \code{shinylight_initial_data} to this supplied JSON
string.}
}
\value{
The server object, can be passed to \code{\link{slStop}}
}
\description{
It will serve files from the app directories specified by appDirs.
If a file is requested that is not in one of those directories, the
files in Shinylight's own inst/www directory will be served.
Some paths have special meanings: \code{/} returns
\code{/index.html}, \code{/lang/} is redirected to
\code{/locales/<language-code>/} depending
on the language selected in the request's Accept-Language
header (that is, the browser's language setting) and the
availability of the file requested. A POST request to \code{/init}
with a \code{data} parameter will return \code{/index.html}, except
that if the file has a line containing \code{shinylight_initial_data =}
then this line with be replaced with a line initializing
\code{shinylight_initial_data} to the data passed. This is used in
\code{shinylight-framework} to permit linking to a framework app
with specific data preloaded -- the text should be as is downloaded
with the "Save Data" button. Of course, this is available to
non-framework apps, too.
}
