% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat_app.R
\name{chat_app}
\alias{chat_app}
\alias{chat_mod_ui}
\alias{chat_mod_server}
\title{Open a live chat application in the browser}
\usage{
chat_app(client, ...)

chat_mod_ui(id, ..., client = NULL, messages = NULL)

chat_mod_server(id, client)
}
\arguments{
\item{client}{A chat object created by \pkg{ellmer}, e.g.
\code{\link[ellmer:chat_openai]{ellmer::chat_openai()}} and friends.}

\item{...}{In \code{chat_app()}, additional arguments are passed to
\code{\link[shiny:shinyApp]{shiny::shinyApp()}}. In \code{chat_mod_ui()}, additional arguments are passed to
\code{\link[=chat_ui]{chat_ui()}}.}

\item{id}{The chat module ID.}

\item{messages}{Initial messages shown in the chat, used when \code{client} is not
provided or when the chat \code{client} doesn't already contain turns. Passed to
\code{messages} in \code{\link[=chat_ui]{chat_ui()}}.}
}
\value{
\itemize{
\item \code{chat_app()} returns a \code{\link[shiny:shinyApp]{shiny::shinyApp()}} object.
\item \code{chat_mod_ui()} returns the UI for a shinychat module.
\item \code{chat_mod_server()} includes the shinychat module server logic, and
and returns the last turn upon successful chat completion.
}
}
\description{
Create a simple Shiny app for live chatting using an \link[ellmer:Chat]{ellmer::Chat} object.
Note that these functions will mutate the input \code{client} object as
you chat because your turns will be appended to the history.
}
\section{Functions}{
\itemize{
\item \code{chat_app()}: A simple Shiny app for live chatting.

\item \code{chat_mod_ui()}: A simple chat app module UI.

\item \code{chat_mod_server()}: A simple chat app module server.

}}
\examples{
\dontrun{
# Interactive in the console ----
client <- ellmer::chat_claude()
chat_app(client)

# Inside a Shiny app ----
library(shiny)
library(bslib)
library(shinychat)

ui <- page_fillable(
  titlePanel("shinychat example"),

  layout_columns(
    card(
      card_header("Chat with Claude"),
      chat_mod_ui(
        "claude",
        messages = list(
          "Hi! Use this chat interface to chat with Anthropic's `claude-3-5-sonnet`."
        )
      )
    ),
    card(
      card_header("Chat with ChatGPT"),
      chat_mod_ui(
        "openai",
        messages = list(
          "Hi! Use this chat interface to chat with OpenAI's `gpt-4o`."
        )
      )
    )
  )
)

server <- function(input, output, session) {
  claude <- ellmer::chat_claude(model = "claude-3-5-sonnet-latest") # Requires ANTHROPIC_API_KEY
  openai <- ellmer::chat_openai(model = "gpt-4o") # Requires OPENAI_API_KEY

  chat_mod_server("claude", claude)
  chat_mod_server("openai", openai)
}

shinyApp(ui, server)
}

}
