% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-multi.R
\name{updateMultiInput}
\alias{updateMultiInput}
\title{Change the value of a multi input on the client}
\usage{
updateMultiInput(
  session,
  inputId,
  label = NULL,
  selected = NULL,
  choices = NULL
)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set.}

\item{selected}{The values selected. To select none, use \code{character(0)}.}

\item{choices}{The new choices for the input.}
}
\description{
Change the value of a multi input on the client
}
\note{
Thanks to \href{https://github.com/ifellows}{Ian Fellows} for this one !
}
\examples{
if (interactive()) {

library(shiny)
library(shinyWidgets)

fruits <- c("Banana", "Blueberry", "Cherry",
            "Coconut", "Grapefruit", "Kiwi",
            "Lemon", "Lime", "Mango", "Orange",
            "Papaya")

ui <- fluidPage(
  tags$h2("Multi update"),
  multiInput(
    inputId = "my_multi",
    label = "Fruits :",
    choices = fruits,
    selected = "Banana",
    width = "350px"
  ),
  verbatimTextOutput(outputId = "res"),
  selectInput(
    inputId = "selected",
    label = "Update selected:",
    choices = fruits,
    multiple = TRUE
  ),
  textInput(inputId = "label", label = "Update label:")
)

server <- function(input, output, session) {

  output$res <- renderPrint(input$my_multi)

  observeEvent(input$selected, {
    updateMultiInput(
      session = session,
      inputId = "my_multi",
      selected = input$selected
    )
  })

  observeEvent(input$label, {
    updateMultiInput(
      session = session,
      inputId = "my_multi",
      label = input$label
    )
  }, ignoreInit = TRUE)
}

shinyApp(ui, server)

}
}
\seealso{
\code{\link{multiInput}}
}
