% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Link.R
\name{f7Link}
\alias{f7Link}
\title{Framework7 link}
\usage{
f7Link(label = NULL, href, icon = NULL)
}
\arguments{
\item{label}{Optional link text.}

\item{href}{Link source, url.}

\item{icon}{Link icon, if any. Must pass \link{f7Icon}.}
}
\description{
Link to point toward external content.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
    title = "Links",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Link"),
     f7Link(label = "Google", href = "https://www.google.com"),
     f7Link(href = "https://www.twitter.com", icon = f7Icon("bolt_fill"))
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
