% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Page.R
\name{f7TabLayout}
\alias{f7TabLayout}
\title{Create a Framework7 page with tab layout}
\usage{
f7TabLayout(..., navbar, panels = NULL, appbar = NULL)
}
\arguments{
\item{...}{Slot for \link{f7Tabs}.}

\item{navbar}{Slot for \link{f7Navbar}.}

\item{panels}{Slot for \link{f7Panel}.
Wrap in \link[shiny]{tagList} if multiple panels.}

\item{appbar}{Slot for \link{f7Appbar}.}
}
\description{
Build a Framework7 page with tab layout
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
  ui = f7Page(
    title = "Tab Layout",
    f7TabLayout(
      panels = tagList(
       f7Panel(title = "Left Panel", side = "left", theme = "light", "Blabla", effect = "cover"),
       f7Panel(title = "Right Panel", side = "right", theme = "dark", "Blabla", effect = "cover")
      ),
      navbar = f7Navbar(
        title = "Tabs",
        hairline = FALSE,
        shadow = TRUE,
        left_panel = TRUE,
        right_panel = TRUE
      ),
      f7Tabs(
        animated = TRUE,
        f7Tab(
          tabName = "Tab 1",
          icon = f7Icon("email"),
          active = TRUE,
          f7Shadow(
            intensity = 10,
            hover = TRUE,
            f7Card(
              title = "Card header",
              sliderInput("obs1", "Number of observations", 0, 1000, 500),
              plotOutput("distPlot1"),
              footer = tagList(
                f7Button(color = "blue", label = "My button", src = "https://www.google.com"),
                f7Badge("Badge", color = "green")
              )
            )
          )
        ),
        f7Tab(
          tabName = "Tab 2",
          icon = f7Icon("today"),
          active = FALSE,
          f7Shadow(
            intensity = 10,
            hover = TRUE,
            f7Card(
              title = "Card header",
              sliderInput("obs2", "Number of observations", 0, 10000, 5000),
              plotOutput("distPlot2"),
              footer = tagList(
                f7Button(color = "blue", label = "My button", src = "https://www.google.com"),
                f7Badge("Badge", color = "green")
              )
            )
          )
        ),
        f7Tab(
          tabName = "Tab 3",
          icon = f7Icon("cloud_upload"),
          active = FALSE,
          f7Shadow(
            intensity = 10,
            hover = TRUE,
            f7Card(
              title = "Card header",
              sliderInput("obs3", "Number of observations", 0, 10, 5),
              plotOutput("distPlot3"),
              footer = tagList(
                f7Button(color = "blue", label = "My button", src = "https://www.google.com"),
                f7Badge("Badge", color = "green")
              )
            )
          )
        )
      )
    )
  ),
  server = function(input, output) {
    output$distPlot1 <- renderPlot({
      dist <- rnorm(input$obs1)
      hist(dist)
    })
    output$distPlot2 <- renderPlot({
      dist <- rnorm(input$obs2)
      hist(dist)
    })
    output$distPlot3 <- renderPlot({
      dist <- rnorm(input$obs3)
      hist(dist)
    })
  }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
