% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifest.R
\name{create_manifest}
\alias{create_manifest}
\title{Create a manifest for your shiny app}
\usage{
create_manifest(
  path,
  name = "My App",
  shortName = "My App",
  description = "What it does!",
  lang = "en-US",
  startUrl,
  display = c("minimal-ui", "standalone", "fullscreen", "browser"),
  icons
)
}
\arguments{
\item{path}{package path.}

\item{name}{App name.}

\item{shortName}{App short name.}

\item{description}{App description}

\item{lang}{App language (en-US by default).}

\item{startUrl}{Page to open at start.}

\item{display}{Display mode. Choose among \code{c("minimal-ui", "standalone", "fullscreen", "browser")}.
In practice, you want the standalone mode so that the app looks like a native app.}

\item{icons}{Dataframe containing icons specs for instance \code{data.frame(src = rep("icons/128x128.png", 10), sizes = rep("128x128", 10), types = rep("image/png", 10))}.
src gives the icon path (in the www folder for instance), sizes gives the size and types the type.}
}
\value{
This function creates a www folder for your shiny app. Must specify the path.
It also creates 2 additional folders to contain icons and splashscreen (splashscreen creation
is not automatic for iOS). It also creates the manifest.json file in this www folder.
You still have to create your own icons and splashscreen!
}
\description{
This is a central piece if you want to have your app standalone for instance
}
\note{
See \url{https://developer.mozilla.org/en-US/docs/Web/Manifest} for more informations.
}
\examples{
create_manifest(
  path = tempdir(),
  name = "My App",
  shortName = "My App",
  description = "What it does!",
  lang = "en-US",
  startUrl = "https://www.google.com/",
  display = "standalone",
  icons = data.frame(
    src = rep("icons/128x128.png", 10),
    sizes = rep("128x128", 10),
    types = rep("image/png", 10)
  )
)
}
