% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updatePlotlyH.R
\name{updatePlotlyH}
\alias{updatePlotlyH}
\title{Wrapper for updating plotly with large-sized data}
\usage{
updatePlotlyH(session, outputId, relayout_order, sd_obj, enforce = FALSE)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{outputId}{Character. The outputId of the plotly that will be
down-sampled}

\item{relayout_order}{Named list.
The list generated by \code{plotlyjs_relayout},
which is obtained using \code{plotly::event_data}.}

\item{sd_obj}{The \code{shiny_downsampler} instance
that contains the original data and used for generating the figure.}

\item{enforce}{Boolean.
It it is \code{TRUE}, the figure will be updated even if
\code{relayout_order} is \code{NULL}.}
}
\description{
using this function, figure updater is registered in shiny app.
The figure updater receives events in plotly and update the figure.
}
\examples{
\donttest{
data(noise_fluct)
fig <- plot_ly(x = d$x, y = d$y, type = "scatter", mode = "lines")

shd <- shiny_downsampler$new(figure = fig)

ui <- fluidPage(
  plotlyOutput(outputId = "hp", width = "800px", height = "600px")
)

server <- function(input, output, session) {

  output$hp <- renderPlotly(shd$figure)

  observeEvent(plotly::event_data("plotly_relayout"),{
    updatePlotlyH(session, "hp", plotly::event_data("plotly_relayout"), shd)
  })

}

shinyApp(ui = ui, server = server)
}
}
