% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregators.R
\docType{class}
\name{nth_pnt_aggregator}
\alias{nth_pnt_aggregator}
\title{Aggregation which returns every Nth point.}
\format{
An \code{R6::R6Class} object
}
\description{
Aggregation by extracting every Nth data.
}
\examples{
data(noise_fluct)
agg <- nth_pnt_aggregator$new()
d_agg <- agg$aggregate(noise_fluct$sec, noise_fluct$level, 1000)
plot(d_agg$x, d_agg$y, type = "l")
}
\section{Super class}{
\code{\link[shinyHugePlot:abstract_aggregator]{shinyHugePlot::abstract_aggregator}} -> \code{nth_pnt_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-nth_pnt_aggregator-new}{\code{nth_pnt_aggregator$new()}}
\item \href{#method-nth_pnt_aggregator-clone}{\code{nth_pnt_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/abstract_aggregator.html#method-abstract_aggregator-aggregate'><code>shinyHugePlot::abstract_aggregator$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nth_pnt_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-nth_pnt_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nth_pnt_aggregator$new(interleave_gaps = FALSE, nan_position = "end")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, nan_position}}{Arguments pass to the constructor of
the \code{abstract_aggregator} class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nth_pnt_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-nth_pnt_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nth_pnt_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
