% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{uinumericinput}
\alias{uinumericinput}
\title{Create Semantic UI Numeric Input}
\usage{
uinumericinput(name, value, min = NA, max = NA, step = NA)
}
\arguments{
\item{name}{Input name. Reactive value is available under \code{input[[name]]}.}

\item{value}{Initial value of the numeric input.}

\item{min}{Minimum allowed value.}

\item{max}{Maximum allowed value.}

\item{step}{Interval to use when stepping between min and max.}
}
\description{
This creates a default numeric input using Semantic UI. The input is available
under \code{input[[name]]}.
}
\details{
The inputs are updateable by using \code{\link[shiny]{updateNumericInput}}.
}
\examples{
library(shiny)
library(shiny.semantic)

# Text input
uiinput(
  tags$label("Numeric Input"),
  uinumericinput("ex", 10)
)

}
