% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkbox.R
\name{simple_checkbox}
\alias{simple_checkbox}
\title{Create Semantic UI checkbox}
\usage{
simple_checkbox(id, label, type = NULL, is_marked = TRUE, style = NULL)
}
\arguments{
\item{id}{Input name. Reactive value is available under input[[name]].}

\item{label}{Text to be displayed with checkbox.}

\item{type}{Type of checkbox.}

\item{is_marked}{Defines if checkbox should be marked. Default TRUE.}

\item{style}{Style of the widget.}
}
\description{
This creates a checkbox using Semantic UI styles.
}
\details{
The inputs are updateable by using \code{\link[shiny]{updateCheckboxInput}}.

The following \code{type}s are allowed:
\itemize{
\item{NULL}{The standard checkbox (default)}
\item{toggle}{Each checkbox has a toggle form}
\item{slider}{Each checkbox has a simple slider form}
}
}
\examples{
simple_checkbox("example", "Check me", is_marked = FALSE)

}
