% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_login_server.R
\name{login_server}
\alias{login_server}
\title{Login server module}
\usage{
login_server(
  id = "login_system",
  db_method,
  mail_method,
  appname,
  appaddress,
  lang = "en",
  gsheet_file,
  sqlite_db,
  gmailr_user,
  emayili_user,
  emayili_password,
  emayili_host,
  emayili_port,
  custom_txts = NULL,
  use_login_modals = list(UserNotFound = T, WrongPass = T, Success = T)
)
}
\arguments{
\item{id}{the id of the module. Defaults to "login_system" for all of the modules contained within the package. If you plan to use serveral login systems inside your app or for any other reason need to change it, remember to keep consistent id for all elements of module.}

\item{db_method}{the character string containing chosen database container, either: \code{"gsheet"} (needing installation of 'googlesheets4' package) or \code{"sqlite"} (needing installation of 'DBI' and 'RSQLite' packages)}

\item{mail_method}{the character string containing chosen method of sending emails, either: \code{"gmailr"} (needing installation of 'gmailr' package) \code{"emayili"} (needing installation of 'emayili' package)}

\item{appname}{the character string containing the name of your application (used in automatic e-mails for information purposes)}

\item{appaddress}{the character value containing the web address of your application (used in automatic e-mails for information purposes)}

\item{lang}{specifies the app used language. Accepts "en" or "pl". Defaults to "en"}

\item{gsheet_file}{the ID of your 'googlesheet' file holding the database. It is contained within URL address of your googlesheet (for: \code{db_method = "gsheet"})}

\item{sqlite_db}{the path to your 'SQLite' database (for: \code{db_method = "sqlite"})}

\item{gmailr_user}{your gmail address (for: \code{db_method = "gmailr"})}

\item{emayili_user}{your email address, also used as login to your email account (for: \code{db_method = "emayili"})}

\item{emayili_password}{password to your email account (for: \code{db_method = "emayili"})}

\item{emayili_host}{host of your email box (for: \code{db_method = "emayili"})}

\item{emayili_port}{port of your email box (for: \code{db_method = "emayili"})}

\item{custom_txts}{named list containing customized texts. For more details,
see documentation for 'reglog_txt'. Provided list can contain only elements
used by this function, but it is recommended to provide the same list for
every 'shiny.reglog' function}

\item{use_login_modals}{list of logicals indicating if the modalDialog after log-in should be shown. Defaults to named list of logicals:
\itemize{
\item{UserNotFound = T}
\item{WrongPass = T}
\item{Success = T}
}}
}
\value{
reactiveValues() object with three elements:

\code{is_logged}, containing boolean describing authorization status

\code{user_id}, containing the logged user identification name. When not logged, it contains the timestamp of session start

\code{user_mail}, containing the logged user mail. When not logged, it is empty character string of nchar() value 0: ("")

\code{last_state_change}, containing string describing last change of login system state. Currently only supports state changes during login procedure
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function has become deprecated. New RegLog system is based on \link{RegLogServer} R6 class.

Shiny server module for the optional login/registration system
This function creates a server module to handle other modules of the system: \code{login_UI()}, \code{password_reset_UI()} and \code{register_UI}
It uses database contained in 'googlesheet' file on your 'gdrive' or 'SQLite' database locally to read and write data of the users. You need to create a 'googlesheet' or 'SQLite' using \code{create_gsheet_db()} or \code{create_sqlite_db()} respectively.
}
\details{
The module logic creates a \code{reactiveValues()} object with loaded database of users and reset codes stored in \code{session$userData}. It allows to cut the reading from database to only one read per loading of the app - unfortunately it makes the app run slowly if the database of users gets very long.

Registration of new account mails the confirmation e-mail to the end user on provided e-mail.

Provided e-mail is needed for password reset: 10 digits code is generated and mailed to the user to confirm its identity. Reset code remains valid for 24 hours.
\subsection{Authorization}{
\itemize{
\item When using db_method of "gsheet" you need to authorize access to your google drive outside of the functions (using \code{googlesheets4:gs_auth()} with default scopes: \code{"https://www.googleapis.com/auth/spreadsheets"})
\item When using mail_method of "emayili" you need to allow "less secure apps" to use your mailbox
\item When using mail_method of "gmailr" you need to authorize access to your gmail box by creating Oauth2 App on 'Google Cloud Platform' and passing it to \code{gmailr::gm_auth_configure()} and allowing scopes: \code{"https://www.googleapis.com/auth/gmail.send"}
}
}

\subsection{Security}{
\itemize{
\item Both passwords and reset codes are hashed with the help of 'scrypt' package for the extra security
\item gmailr mail_method seems to be more secure if you intend to use 'gmail' account to send emails. 'emayili' is suggested only when using other mailboxes.
}
}
}
\examples{
## Only run this example in interactive R sessions

if(interactive()){
  
  #### example of db_method = "sqlite" and mail_method = "emayili"
  
  library(shiny)
  library(shiny.reglog)
  
  # initializing sqlite
  
  sqlite.path <- tempfile(fileext = "sqlite")
  create_sqlite_db(sqlite.path)
  database <- sqlite_get_db(sqlite.path)
  
  # Define UI containing shiny.reglog modules
  ui <- fluidPage(
    
    headerPanel(title = "shiny.reglog test"),
    
    tabsetPanel(
      tabPanel("Values", 
               # table of returned data for active user
               dataTableOutput("active_user_values"),
               # table of session$userData$reactive_db$user_db loaded at the start of session
               dataTableOutput("user_db"),
               # table of session$userData$reactive_db$reset_db loaded at the start of session
               dataTableOutput("reset_db")
      ),
      tabPanel("Login", login_UI()),
      tabPanel("Register", register_UI()),
      tabPanel("Reset Password", password_reset_UI()),
      tabPanel("Logout", logout_button())
      
    )
  )
  
  server <- function(input, output, session) {
    
    # login server with specified methods for database and mailing
    # to run it you need to replace placeholders with your details and 
    # cofigure it for your needs
    
    auth <- login_server(
      db_method = "sqlite",
      mail_method = "emayili",
      appname = "shiny.reglog example",
      appaddress = "not-on-net.com",
      sqlite_db = sqlite.path,
      # arguments below need configuration for your mailing account
      emayili_user = "your_email_address",
      emayili_password = "your_email_password",
      emayili_port = "your_email_box_port",
      emayili_host = "your_email_box_host"
    )
    
    # table of values returned by login_server
    
    output$active_user_values <- renderDataTable({
      data.frame(is_logged = auth$is_logged,
                 user_id = auth$user_id,
                 user_mail = auth$user_mail
      )
    })
    
    # tibbles contained within session$userData$reactive_db
   
    output$user_db <- renderDataTable(
      session$userData$reactive_db$user_db
    )
    
    output$reset_db <- renderDataTable(
      session$userData$reactive_db$reset_db
    )
  }
  
  # Run the application 
  shinyApp(ui = ui, server = server)
  
}

}
\seealso{
\code{\link[=login_UI]{login_UI()}} for the login window in UI

\code{\link[=password_reset_UI]{password_reset_UI()}} for the password reset window in UI

\code{\link[=register_UI]{register_UI()}} for the registration window in UI
}
\keyword{internal}
