% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{format_text_r}
\alias{format_text_r}
\alias{html_highlight_code}
\title{Get re-formatted \code{R} expressions in characters}
\usage{
format_text_r(
  expr,
  quoted = FALSE,
  reformat = TRUE,
  width.cutoff = 80L,
  indent = 2,
  wrap = TRUE,
  args.newline = TRUE,
  blank = FALSE,
  ...
)

html_highlight_code(
  expr,
  class = NULL,
  quoted = FALSE,
  reformat = TRUE,
  copy_on_click = TRUE,
  width.cutoff = 80L,
  indent = 2,
  wrap = TRUE,
  args.newline = TRUE,
  blank = FALSE,
  ...,
  hover = c("overflow-visible-on-hover", "overflow-auto")
)
}
\arguments{
\item{expr}{\code{R} expressions}

\item{quoted}{whether \code{expr} is quoted}

\item{reformat}{whether to reformat}

\item{width.cutoff, indent, wrap, args.newline, blank, ...}{passed to
\code{\link[formatR]{tidy_source}}}

\item{class}{class of \code{<pre>} tag}

\item{copy_on_click}{whether to copy to clipboard if user clicks on the
code; default is true}

\item{hover}{mouse hover behavior}
}
\value{
\code{format_text_r} returns characters,
\code{html_highlight_code} returns the 'HTML' tags wrapping expressions
in \code{<pre>} tag
}
\description{
Get re-formatted \code{R} expressions in characters
}
\examples{

s <- format_text_r(print(local({a<-1;a+1})))
cat(s)

x <- info_box("Message", icon = "cogs")
s <- format_text_r(get_construct_string(x),
                   width.cutoff = 15L, quoted = TRUE)
cat(s)


}
\seealso{
\code{\link{get_construct_string}}
}
