% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipboard.R
\name{clipboardOutput}
\alias{clipboardOutput}
\alias{renderClipboard}
\title{Generates outputs that can be written to clipboards with one click}
\usage{
clipboardOutput(
  outputId = rand_string(),
  message = "Copy to clipboard",
  clip_text = "",
  class = NULL,
  as_card_tool = FALSE
)

renderClipboard(
  expr,
  env = parent.frame(),
  quoted = FALSE,
  outputArgs = list()
)
}
\arguments{
\item{outputId}{the output id}

\item{message}{tool tip to show when mouse hovers on the element}

\item{clip_text}{the initial text to copy to clipboards}

\item{class}{'HTML' class of the element}

\item{as_card_tool}{whether to make the output as \code{\link{card_tool}}}

\item{expr}{expression to evaluate; the results will replace
\code{clip_text}}

\item{env}{environment to evaluate \code{expr}}

\item{quoted}{whether \code{expr} is quoted}

\item{outputArgs}{used to replace default arguments of \code{clipboardOutput}}
}
\value{
'HTML' elements that can write to clip-board once users click on
them.
}
\description{
Generates outputs that can be written to clipboards with one click
}
\examples{
clipboardOutput(clip_text = "Hey there")

}
