% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explanatory_performance.R
\name{PlotROC}
\alias{PlotROC}
\title{Receiver Operating Characteristic (ROC) curve}
\usage{
PlotROC(
  roc,
  xlab = "False Positive Rate",
  ylab = "True Positive Rate",
  col = "red",
  col_band = NULL,
  alpha = 0.5,
  lwd = 1,
  lty = 1,
  quantiles = c(0.05, 0.95),
  add = FALSE
)
}
\arguments{
\item{roc}{output of \code{\link{ROC}} or
\code{\link{ExplanatoryPerformance}}.}

\item{xlab}{label of the x-axis.}

\item{ylab}{label of the y-axis.}

\item{col}{colour of the point-wise median curve.}

\item{col_band}{colour of the band defined by point-wise \code{quantiles}.}

\item{alpha}{level of opacity for the band.}

\item{lwd}{line width, as in \code{\link[graphics]{par}}. Only used if
\code{stability} is the output of \code{\link{BiSelection}}.}

\item{lty}{line type, as in \code{\link[graphics]{par}}. Only used if
\code{stability} is the output of \code{\link{BiSelection}}.}

\item{quantiles}{point-wise quantiles of the performances defining the band.}

\item{add}{logical indicating if the curve should be added to the current
plot.}
}
\value{
A plot.
}
\description{
Plots the True Positive Rate (TPR) as a function of the False Positive Rate
(FPR) for different thresholds in predicted probabilities. If the results
from multiple ROC analyses are provided (e.g. output of
\code{\link{ExplanatoryPerformance}} with large \code{K}), the point-wise
median is represented and flanked by a transparent band defined by
point-wise \code{quantiles}.
}
\examples{
# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 500, pk = 10, family = "binomial")

# Balanced split: 50\% variable selection set and 50\% for evaluation of performances
ids_train <- Resample(
  data = simul$ydata,
  tau = 0.5, family = "binomial"
)
xtrain <- simul$xdata[ids_train, ]
ytrain <- simul$ydata[ids_train, ]
xtest <- simul$xdata[-ids_train, ]
ytest <- simul$ydata[-ids_train, ]

# Stability selection
stab <- VariableSelection(xdata = xtrain, ydata = ytrain, family = "binomial")

# Evaluation of the performances on recalibrated models (K=1)
roc <- ExplanatoryPerformance(
  xdata = xtest, ydata = ytest,
  stability = stab, n_thr = NULL
)
PlotROC(roc)

# Using more recalibration/test splits
roc <- ExplanatoryPerformance(
  xdata = xtest, ydata = ytest,
  stability = stab, K = 100
)
PlotROC(roc)

# Comparison with saturated model
roc <- ExplanatoryPerformance(
  xdata = xtest, ydata = ytest,
  family = "binomial", K = 100
)
PlotROC(roc, col = "blue", col_band = "blue", add = TRUE)
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{Recalibrate}}

Other prediction performance functions: 
\code{\link{ExplanatoryPerformance}()},
\code{\link{Incremental}()},
\code{\link{PlotIncremental}()},
\code{\link{ROC}()}
}
\concept{prediction performance functions}
