% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeR.R
\name{generateShapeCoefficients}
\alias{generateShapeCoefficients}
\title{Get wavelet/Fourier coefficients and basic shape variables}
\usage{
generateShapeCoefficients(object,...)
}
\arguments{
\item{object}{\code{\linkS4class{shapeR}} object}

\item{...}{Additional parameters to be passed to the \code{\link{wd}} function of the \code{\link{wavethresh}} package for the wavelet decomposition of the otolith outlines}
}
\value{
A \code{\linkS4class{shapeR}} object with values in slots:
\itemize{
  \item wavelet.coef.raw
  \item fourier.coef.raw
  \item shape.coef.raw
}
}
\description{
Generates shape variables based on Fourier/wavelet reconstruction. Wavelet coefficients for wavelet. Basic shape parameters are also collected (area, length, width, perimeter).
}
\examples{
\donttest{
data(shape)
shape = generateShapeCoefficients(shape)}
}
\references{
Nason, G. (2012). \code{\link{wavethresh}}: Wavelets statistics and transforms. R package, version 4.5.

Claude, J. (2008). Morphometrics with R. Springer. 316 p.
}
\seealso{
\code{\link[wavethresh]{wavethresh}}
}
\author{
Lisa Anne Libungan & Snaebjorn Palsson
}
