% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shapeR.R
\name{remove.outline}
\alias{remove.outline}
\title{Remove otolith outline}
\usage{
remove.outline(object, folder = "", fname = "")
}
\arguments{
\item{object}{A \code{\linkS4class{shapeR}} object}

\item{folder}{The folder name where the outline that needs to be removed is stored}

\item{fname}{The file name of the outline to be removed}
}
\value{
\code{\linkS4class{shapeR}} object
}
\description{
A function for removing an otolith outline from the file 'outline.list'. Typically done if the image is of bad quality and needs to be enhanced in a image processing software
}
\examples{
\dontrun{
#Use test data from example in Libungan and Palsson (2015):
shape = shapeR("ShapeAnalysis/","FISH.csv")
shape = detect.outline(shape)
#If otolith outline in folder IC named 403_1 needs to be removed
shape = remove.outline(shape, "IC", "403_1")}
}
\author{
Lisa Anne Libungan
}
\references{
Libungan LA and Palsson S (2015) ShapeR: An R Package to Study Otolith Shape Variation among Fish Populations. PLoS ONE 10(3): e0121102. \url{http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0121102}
}

