% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sgs_cv}
\alias{plot.sgs_cv}
\title{plot a \code{"sgs_cv"} object}
\usage{
\method{plot}{sgs_cv}(x, how_many = 10, ...)
}
\arguments{
\item{x}{Object an object of class \code{"sgs_cv"} from a call to \code{\link[=fit_sgs]{fit_sgs()}}.}

\item{how_many}{Defines how many predictors to plot. Plots the predictors in decreasing order of largest absolute value.}

\item{...}{further arguments passed to base function.}
}
\value{
A list containing:
\item{response}{The predicted response. In the logistic case, this represents the predicted class probabilities.}
\item{class}{The predicted class assignments. Only returned if type = "logistic" in the \code{"sgs"} object.}
}
\description{
Plots the pathwise solution of a cross-validation fit, from a call to \code{\link[=fit_sgs_cv]{fit_sgs_cv()}}
}
\examples{
# specify a grouping structure
groups = c(1,1,2,2,3)
# generate data
data = generate_toy_data(p=5, n=4, groups = groups, seed_id=3,signal_mean=20,group_sparsity=1)
# run SGS 
cv_model = fit_sgs_cv(X = data$X, y = data$y, groups=groups, type = "linear", 
nlambda = 20, nfolds=10, alpha = 0.95, vFDR = 0.1, gFDR = 0.1, 
min_frac = 0.05, standardise="l2",intercept=TRUE,verbose=FALSE)
plot(cv_model, how_many = 10)
}
\seealso{
\code{\link[=fit_sgs_cv]{fit_sgs_cv()}}

Other SGS-methods: 
\code{\link{predict.sgs}()},
\code{\link{print.sgs}()}
}
\concept{SGS-methods}
