% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_glg.R
\name{order_glg}
\alias{order_glg}
\title{Random Sampling of Order Statistics from a Generalized Log-gamma Distribution}
\usage{
order_glg(size, mu, sigma, lambda, k, n)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{mu}{numeric, represents the location parameter. Default value is 0.}

\item{sigma}{numeric, represents the scale parameter. Default value is 1.}

\item{lambda}{numeric, represents the shape parameter. Default value is 1.}

\item{k}{numeric, represents the Kth smallest value from a sample.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}
}
\description{
\code{order_glg} is used to obtain a random sample of order statistics from a Generalized Log-gamma Distribution.
}
\examples{
{
# A random sample of size 10 of order statistics from a Extreme Value Distribution.
order_glg(10,0,1,1,1,50)}
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Naradajah, S. and Rocha, R. (2016) Newdistns: An R Package for New Families of Distributions, Journal of Statiscal Software.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
