% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{entropy}
\alias{entropy}
\title{Tool to calculate the entropy for a generalized log-gamma distribution.}
\usage{
entropy(mu, sigma, lambda)
}
\arguments{
\item{mu}{numeric, represent the location parameter of a generalized log-gamma distribution. Default value is 0.}

\item{sigma}{numeric, represent the scale parameter of a generalized log-gamma distribution. Default value is 1.}

\item{lambda}{numeric, represent the shape parameter of a generalized log-gamma distribution. Default value is 1.}
}
\description{
\code{entropy} is used to obtain the entropy for a generalized log-gamma distribution.
}
\examples{
entropy(0,1,-1)    # Extreme value type I distribution, maximum case.
entropy(0,1,1)     # Extreme value type I distribution, minimum case.
entropy(0,1,0.077) # Standard normal distribution.
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>, G. Paula and L. Vanegas.
}
