% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgl_error.R
\name{Err}
\alias{Err}
\title{Generic function for computing error rates}
\usage{
Err(object, data, response, ...)
}
\arguments{
\item{object}{an object}

\item{data}{a data object}

\item{response}{a response object}

\item{...}{additional parameters (optional)}
}
\value{
a vector of length \code{nmod(object)} or a matrix with \code{nmod(object)} columns containing error rates for the models
}
\description{
Compute and returns an error rate for each model contained in \code{x}.
See details for generic use cases.
}
\details{
The following generic use case should be supported (see for example \pkg{msgl} package for an implementation):

\enumerate{
\item With \code{fit} a sgl fit object with models estimated using \code{x} data, the code

\code{Err(fit, x)}

should return a vector with the \emph{training errors} of the models.

\item With \code{x.new} a new data set with known responses \code{response.new}, the code

\code{Err(fit, x.new, response.new)}

should return a vector with the errors of the models when applied to the new data set.
\item With \code{fit.cv} a sgl cross validation object, the code

\code{Err(fit.cv)}

should return a vector with estimates of the \emph{expected generalization errors} of the models (i.e. the cross validation errors).

\item If subsampling is supported then, with \code{fit.sub} a sgl subsampling object, the code

\code{Err(fit.sub)}

should return a matrix with the test errors (each column corresponding to a model, i.e. rows corresponds to tests).
}
}
\author{
Martin Vincent
}
\seealso{
compute_error
}

