\name{identify.point}
\title{Identify points on a Point Object}
\usage{identify.point(x, ..., v) }
\alias{identify.point}
\arguments{
  \item{x}{a point object generated by \code{point()}}
  \item{v}{use values of variable \code{"v"} as labels}
  \item{...}{additional arguments to \code{idententify}}
}
\value{An integer vector containing the indexes of
  the identified points.}
\description{
  Plot variable values next to locations after the \code{plot.point()} function. }
\seealso{\code{\link{plot.point}}}
\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.point"))==0){example(point)}
}
plot(maas.point)
# use indices as labels:
identify(maas.point)
# use values as labels:
identify(maas.point,v="zinc")
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
\keyword{spatial}
