% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfg.R
\name{sfg_multipolygon}
\alias{sfg_multipolygon}
\title{sfg multipolygon}
\usage{
sfg_multipolygon(
  obj,
  x = NULL,
  y = NULL,
  z = NULL,
  m = NULL,
  polygon_id = NULL,
  linestring_id = NULL,
  close = TRUE
)
}
\arguments{
\item{obj}{matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}

\item{polygon_id}{column of ids for polygons (within the multipolygon)}

\item{linestring_id}{column of ids for lines (within polygons)}

\item{close}{logical indicating whether polygons should be closed. If \code{TRUE},
all polygons will be checked and force closed if possible}
}
\value{
\code{sfg} object of MULTIPOLYGON geometry
}
\description{
constructs sfg MULTIPOLYGON object
}
\examples{

df <- data.frame(
  polygon_id = c(rep(1, 5), rep(2, 10))
  , line_id = c(rep(1, 10), rep(2, 5))
  , x = c(0,0,1,1,0,2,2,5,5,2,3,3,4,4,3)
  , y = c(0,1,1,0,0,2,5,5,2,2,3,4,4,3,3)
  , z = c(1)
  , m = c(1)
)

m <- as.matrix( df )

sfg_multipolygon( df[, c("x","y") ] )

sfg_multipolygon(
  df, x = "x", y = "y", polygon_id = "polygon_id", linestring_id = "line_id"
  )
sfg_multipolygon(
  df, x = "x", y = "y", z = "z", polygon_id = "polygon_id", linestring_id = "line_id"
  )
sfg_multipolygon(
  df, x = "x", y = "y", z = "z", m = "m", polygon_id = "polygon_id", linestring_id = "line_id"
  )


sfg_multipolygon( m[, c("x","y") ] )

sfg_multipolygon(
  m, x = "x", y = "y", polygon_id = "polygon_id", linestring_id = "line_id"
  )
sfg_multipolygon(
  m, x = "x", y = "y", z = "z", polygon_id = "polygon_id", linestring_id = "line_id"
  )
sfg_multipolygon(
  m, x = "x", y = "y", z = "z", m = "m", polygon_id = "polygon_id", linestring_id = "line_id"
  )

}
