% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcr_scenario.R
\name{.check_shock_consistency}
\alias{.check_shock_consistency}
\title{Check shocks for length consistency and warn about risks of using exogenous series}
\usage{
.check_shock_consistency(shock, periods = periods)
}
\arguments{
\item{shock}{A sfcr_shock object}
}
\description{
This function executes two checks and issues one warning.
}
\details{
First, it checks that the start of the shock is not negative and that the end
of the shock is not bigger than the number of periods in the scenario.

Secondly, it checks for consistency on the length of the shocks added to the scenario.
Only two types of exogenous variables are allowed:
\enumerate{
\item The exogenous variable is a constant that is repeated over time;
\item The exogenous variable has exactly the same length as the shock.
}

Furthermore, it throws a warning that using exogenous series in a shock can lead to unexpected
behavior if the length of the shock is not the same as the periods in the scenario.
}
\author{
João Macalós
}
\keyword{internal}
