% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfalcmcross.R
\name{sfalcmcross}
\alias{sfalcmcross}
\alias{print.sfalcmcross}
\alias{bread.sfalcmcross}
\alias{estfun.sfalcmcross}
\title{Latent class stochastic frontier using cross-sectional data}
\usage{
sfalcmcross(
  formula,
  uhet,
  vhet,
  thet,
  logDepVar = TRUE,
  data,
  subset,
  weights,
  wscale = TRUE,
  S = 1L,
  udist = "hnormal",
  start = NULL,
  whichStart = 2L,
  initAlg = "nm",
  initIter = 100,
  lcmClasses = 2,
  method = "bfgs",
  hessianType = 1,
  itermax = 2000L,
  printInfo = FALSE,
  tol = 1e-12,
  gradtol = 1e-06,
  stepmax = 0.1,
  qac = "marquardt"
)

\method{print}{sfalcmcross}(x, ...)

\method{bread}{sfalcmcross}(x, ...)

\method{estfun}{sfalcmcross}(x, ...)
}
\arguments{
\item{formula}{A symbolic description of the model to be estimated based on
the generic function \code{formula} (see section \sQuote{Details}).}

\item{uhet}{A one-part formula to account for heteroscedasticity in the
one-sided error variance (see section \sQuote{Details}).}

\item{vhet}{A one-part formula to account for heteroscedasticity in the
two-sided error variance (see section \sQuote{Details}).}

\item{thet}{A one-part formula to account for technological heterogeneity in
the construction of the classes.}

\item{logDepVar}{Logical. Informs whether the dependent variable is logged
(\code{TRUE}) or not (\code{FALSE}). Default = \code{TRUE}.}

\item{data}{The data frame containing the data.}

\item{subset}{An optional vector specifying a subset of observations to be
used in the optimization process.}

\item{weights}{An optional vector of weights to be used for weighted
log-likelihood. Should be \code{NULL} or numeric vector with positive values.
When \code{NULL}, a numeric vector of 1 is used.}

\item{wscale}{Logical. When \code{weights} is not \code{NULL}, a scaling
transformation is used such that the \code{weights} sums to the sample
size. Default \code{TRUE}. When \code{FALSE} no scaling is used.}

\item{S}{If \code{S = 1} (default), a production (profit) frontier is
estimated: \eqn{\epsilon_i = v_i-u_i}. If \code{S = -1}, a cost frontier is
estimated: \eqn{\epsilon_i = v_i+u_i}.}

\item{udist}{Character string. Distribution specification for the one-sided
error term. Only the half normal distribution \code{'hnormal'} (Aigner
\emph{et al.}, 1977, Meeusen and Vandenbroeck, 1977) is currently
implemented.}

\item{start}{Numeric vector. Optional starting values for the maximum
likelihood (ML) estimation.}

\item{whichStart}{Integer. If \code{'whichStart = 1'}, the starting values
are obtained from the method of moments. When \code{'whichStart = 2'}
(Default), the model is initialized by solving the homoscedastic pooled
cross section SFA model.}

\item{initAlg}{Character string specifying the algorithm used for
initialization and obtain the starting values (when \code{'whichStart = 2'}).
Only \pkg{maxLik} package algorithms are available:
\itemize{ \item \code{'bfgs'}, for Broyden-Fletcher-Goldfarb-Shanno
(see \code{\link[maxLik:maxBFGS]{maxBFGS}})
\item \code{'bhhh'}, for Berndt-Hall-Hall-Hausman
(see \code{\link[maxLik:maxBHHH]{maxBHHH}})
\item \code{'nr'}, for Newton-Raphson (see \code{\link[maxLik:maxNR]{maxNR}})
\item \code{'nm'}, for Nelder-Mead - Default -
(see \code{\link[maxLik:maxNM]{maxNM}})
\item \code{'cg'}, for Conjugate Gradient
(see \code{\link[maxLik:maxCG]{maxCG}}) \item \code{'sann'}, for Simulated
Annealing (see \code{\link[maxLik:maxSANN]{maxSANN}})
}}

\item{initIter}{Maximum number of iterations for initialization algorithm.
Default \code{100}.}

\item{lcmClasses}{Number of classes to be estimated (default = \code{2}). A
maximum of five classes can be estimated.}

\item{method}{Optimization algorithm used for the estimation.  Default =
\code{'bfgs'}. 11 algorithms are available: \itemize{ \item \code{'bfgs'},
for Broyden-Fletcher-Goldfarb-Shanno (see
\code{\link[maxLik:maxBFGS]{maxBFGS}}) \item \code{'bhhh'}, for
Berndt-Hall-Hall-Hausman (see \code{\link[maxLik:maxBHHH]{maxBHHH}}) \item
\code{'nr'}, for Newton-Raphson (see \code{\link[maxLik:maxNR]{maxNR}})
\item \code{'nm'}, for Nelder-Mead (see \code{\link[maxLik:maxNM]{maxNM}})
\item \code{'cg'}, for Conjugate Gradient
(see \code{\link[maxLik:maxCG]{maxCG}}) \item \code{'sann'}, for Simulated
Annealing (see \code{\link[maxLik:maxSANN]{maxSANN}})
\item \code{'ucminf'}, for a quasi-Newton type optimization with BFGS updating of
the inverse Hessian and soft line search with a trust region type monitoring
of the input to the line search algorithm
(see \code{\link[ucminf:ucminf]{ucminf}})
\item \code{'mla'}, for general-purpose optimization based on
Marquardt-Levenberg algorithm (see \code{\link[marqLevAlg:mla]{mla}})
\item \code{'sr1'}, for Symmetric Rank 1 (see
\code{\link[trustOptim:trust.optim]{trust.optim}}) \item \code{'sparse'},
for trust regions and sparse Hessian
(see \code{\link[trustOptim:trust.optim]{trust.optim}}) \item
\code{'nlminb'}, for optimization using PORT routines (see
\code{\link[stats:nlminb]{nlminb}})}}

\item{hessianType}{Integer. If \code{1} (default), analytic Hessian is
returned. If \code{2}, bhhh Hessian is estimated (\eqn{g'g}).}

\item{itermax}{Maximum number of iterations allowed for optimization.
Default = \code{2000}.}

\item{printInfo}{Logical. Print information during optimization. Default =
\code{FALSE}.}

\item{tol}{Numeric. Convergence tolerance. Default = \code{1e-12}.}

\item{gradtol}{Numeric. Convergence tolerance for gradient. Default =
\code{1e-06}.}

\item{stepmax}{Numeric. Step max for \code{ucminf} algorithm. Default =
\code{0.1}.}

\item{qac}{Character. Quadratic Approximation Correction for \code{'bhhh'}
and \code{'nr'} algorithms. If \code{'qac = stephalving'}, the step length
is decreased but the direction is kept. If \code{'qac = marquardt'}
(default), the step length is decreased while also moving closer to the pure
gradient direction. See \code{\link[maxLik:maxBHHH]{maxBHHH}} and
\code{\link[maxLik:maxNR]{maxNR}}.}

\item{x}{an object of class sfalcmcross (returned by the function
\code{\link{sfalcmcross}}).}

\item{...}{additional arguments of frontier are passed to sfalcmcross;
additional arguments of the print, bread, estfun, nobs methods are currently
ignored.}
}
\value{
\code{\link{sfalcmcross}} returns a list of class \code{'sfalcmcross'}
containing the following elements:

\item{call}{The matched call.}

\item{formula}{Multi parts formula describing the estimated model.}

\item{S}{The argument \code{'S'}. See the section \sQuote{Arguments}.}

\item{typeSfa}{Character string. 'Latent Class Production/Profit Frontier, e
= v - u' when \code{S = 1} and 'Latent Class Cost Frontier, e = v + u' when
\code{S = -1}.}

\item{Nobs}{Number of observations used for optimization.}

\item{nXvar}{Number of main explanatory variables.}

\item{nZHvar}{Number of variables in the logit specification of the finite
mixture model (i.e. number of covariates).}

\item{logDepVar}{The argument \code{'logDepVar'}. See the section
\sQuote{Arguments}.}

\item{nuZUvar}{Number of variables explaining heteroscedasticity in the
one-sided error term.}

\item{nvZVvar}{Number of variables explaining heteroscedasticity in the
two-sided error term.}

\item{nParm}{Total number of parameters estimated.}

\item{udist}{The argument \code{'udist'}. See the section
\sQuote{Arguments}.}

\item{startVal}{Numeric vector. Starting value for ML estimation.}

\item{dataTable}{A data frame (tibble format) containing information on data
used for optimization along with residuals and fitted values of the OLS and
ML estimations, and the individual observation log-likelihood. When
\code{weights} is specified an additional variable is also provided in
\code{dataTable}.}

\item{initHalf}{When \code{start = NULL} and \code{whichStart == 2L}.
Initial ML estimation with half normal distribution for the one-sided error
term. Model to construct the starting values for
the latent class estimation. Object of class \code{'maxLik'} and
\code{'maxim'} returned.}

\item{isWeights}{Logical. If \code{TRUE} weighted log-likelihood is
maximized.}

\item{optType}{The optimization algorithm used.}

\item{nIter}{Number of iterations of the ML estimation.}

\item{optStatus}{An optimization algorithm termination message.}

\item{startLoglik}{Log-likelihood at the starting values.}

\item{nClasses}{The number of classes estimated.}

\item{mlLoglik}{Log-likelihood value of the ML estimation.}

\item{mlParam}{Numeric vector. Parameters obtained from ML estimation.}

\item{mlParamMatrix}{Double. Matrix of ML parameters by class.}

\item{gradient}{Numeric vector. Each variable gradient of the ML
estimation.}

\item{gradL_OBS}{Matrix. Each variable individual observation gradient of
the ML estimation.}

\item{gradientNorm}{Numeric. Gradient norm of the ML estimation.}

\item{invHessian}{The covariance matrix of the parameters obtained from the
ML estimation.}

\item{hessianType}{The argument \code{'hessianType'}. See the section
\sQuote{Arguments}.}

\item{mlDate}{Date and time of the estimated model.}
}
\description{
\code{\link{sfalcmcross}} is a symbolic formula based function for the
estimation of the latent class stochastic frontier model (LCM) in the case
of cross-sectional or pooled cross-sectional data. The model is estimated
using maximum likelihood (ML). See Orea and Kumbhakar (2004), Parmeter and
Kumbhakar (2014, p282).

Only the half-normal distribution is possible for the one-sided error term.
Eleven optimization algorithms are available.

The function also accounts for heteroscedasticity in both one-sided and
two-sided error terms, as in Reifschneider and Stevenson (1991), Caudill and
Ford (1993), Caudill \emph{et al.} (1995) and Hadri (1999).

The model can estimate up to five classes.
}
\details{
LCM is an estimation of a finite mixture of production functions:

\deqn{y_i = \alpha_j + \mathbf{x_i^{\prime}} 
\bm{\beta_j} + v_{i|j} - Su_{i|j}}

\deqn{\epsilon_{i|j} = v_{i|j} - Su_{i|j}}

where \eqn{i} is the observation, \eqn{j} is the class, \eqn{y} is the
output (cost, revenue, profit), \eqn{x} is the vector of main explanatory
variables (inputs and other control variables), \eqn{u} is the one-sided
error term with variance \eqn{\sigma_{u}^2}, and \eqn{v} is the two-sided
error term with variance \eqn{\sigma_{v}^2}.

\code{S = 1} in the case of production (profit) frontier function and
\code{S = -1} in the case of cost frontier function.

The contribution of observation \eqn{i} to the likelihood conditional on
class \eqn{j} is defined as:

\deqn{P(i|j) = \frac{2}{\sqrt{\sigma_{u|j}^2 + 
\sigma_{v|j}^2}}\phi\left(\frac{S\epsilon_{i|j}}{\sqrt{
\sigma_{u|j}^2 +\sigma_{v|j}^2}}\right)\Phi\left(\frac{
\mu_{i*|j}}{\sigma_{*|j}}\right)}

where

\deqn{\mu_{i*|j}=\frac{- S\epsilon_{i|j}
\sigma_{u|j}^2}{\sigma_{u|j}^2 + \sigma_{v|j}^2}}

and

\deqn{\sigma_*^2 = \frac{\sigma_{u|j}^2 
\sigma_{v|j}^2}{\sigma_{u|j}^2 + \sigma_{v|j}^2}}

The prior probability of using a particular technology can depend on some
covariates (namely the variables separating the observations into classes)
using a logit specification:

\deqn{\pi(i,j) = \frac{\exp{(\bm{\theta}_j'\mathbf{Z}_{hi})}}{
\sum_{m=1}^{J}\exp{(\bm{\theta}_m'\mathbf{Z}_{hi})}}}

with \eqn{\mathbf{Z}_h} the covariates, \eqn{\bm{\theta}} the coefficients estimated for
the covariates, and \eqn{\exp(\bm{\theta}_J'\mathbf{Z}_h)=1}.

The unconditional likelihood of observation \eqn{i} is simply the average
over the \eqn{J} classes:

\deqn{P(i) = \sum_{m=1}^{J}\pi(i,m)P(i|m)}

The number of classes to retain can be based on information criterion (see
for instance \code{\link[=ic.sfalcmcross]{ic}}).

Class assignment is based on the largest posterior probability. This
probability is obtained using Bayes' rule, as follows for class \eqn{j}:

\deqn{w\left(j|i\right)=\frac{P\left(i|j\right)
\pi\left(i,j\right)}{\sum_{m=1}^JP\left(i|m\right)
\pi\left(i, m\right)}}

To accommodate heteroscedasticity in the variance parameters of the error
terms, a single part (right) formula can also be specified. To impose the
positivity on these parameters, the variances are modelled respectively as:
\eqn{\sigma^2_{u|j} = \exp{(\bm{\delta}_j'\mathbf{Z}_u)}} and \eqn{\sigma^2_{v|j} =
\exp{(\bm{\phi}_j'\mathbf{Z}_v)}}, where \eqn{Z_u} and \eqn{Z_v} are the
heteroscedasticity variables (inefficiency drivers in the case of \eqn{\mathbf{Z}_u})
and \eqn{\bm{\delta}} and \eqn{\bm{\phi}} the coefficients. \code{'sfalcmcross'} only
supports the half-normal distribution for the one-sided error term.

\code{sfalcmcross} allows for the maximization of weighted log-likelihood.
When option \code{weights} is specified and \code{wscale = TRUE}, the weights
are scaled as:

\deqn{new_{weights} = sample_{size} \times 
\frac{old_{weights}}{\sum(old_{weights})}}

For complex problems, non-gradient methods (e.g. \code{nm} or
\code{sann}) can be used to warm start the optimization and zoom in the
neighborhood of the solution. Then a gradient-based methods is recommended
in the second step. In the case of \code{sann}, we recommend to significantly
increase the iteration limit (e.g. \code{itermax = 20000}). The Conjugate
Gradient (\code{cg}) can also be used in the first stage.

A set of extractor functions for fitted model objects is available for
objects of class \code{'sfalcmcross'} including methods to the generic functions
\code{\link[=print.sfalcmcross]{print}},
\code{\link[=summary.sfalcmcross]{summary}},
\code{\link[=coef.sfalcmcross]{coef}},
\code{\link[=fitted.sfalcmcross]{fitted}},
\code{\link[=logLik.sfalcmcross]{logLik}},
\code{\link[=residuals.sfalcmcross]{residuals}},
\code{\link[=vcov.sfalcmcross]{vcov}},
\code{\link[=efficiencies.sfalcmcross]{efficiencies}},
\code{\link[=ic.sfalcmcross]{ic}},
\code{\link[=marginal.sfalcmcross]{marginal}},
\code{\link[=estfun.sfalcmcross]{estfun}} and
\code{\link[=bread.sfalcmcross]{bread}} (from the \CRANpkg{sandwich} package),
\code{\link[lmtest:coeftest]{lmtest::coeftest()}} (from the \CRANpkg{lmtest} package).
}
\note{
In the case of panel data, \code{\link{sfalcmcross}} estimates a pooled
cross-section where the probability of belonging to a class a priori is not
permanent (not fixed over time).
}
\examples{

## Using data on eighty-two countries production (GDP)
# LCM Cobb Douglas (production function) half normal distribution
# Intercept and initStat used as separating variables
cb_2c_h1 <- sfalcmcross(formula = ly ~ lk + ll + yr, thet = ~initStat, 
data = worldprod)
summary(cb_2c_h1)

# summary of the initial ML model
summary(cb_2c_h1$InitHalf)

# Only the intercept is used as the separating variable
# and only variable initStat is used as inefficiency driver
cb_2c_h3 <- sfalcmcross(formula = ly ~ lk + ll + yr, uhet = ~initStat, 
data = worldprod)
summary(cb_2c_h3)

}
\references{
Aigner, D., Lovell, C. A. K., and P. Schmidt. 1977. Formulation
and estimation of stochastic frontier production function models.
\emph{Journal of Econometrics}, \bold{6}(1), 21--37.

Caudill, S. B., and J. M. Ford. 1993. Biases in frontier estimation due to
heteroscedasticity. \emph{Economics Letters}, \bold{41}(1), 17--20.

Caudill, S. B., Ford, J. M., and D. M. Gropper. 1995. Frontier estimation
and firm-specific inefficiency measures in the presence of
heteroscedasticity. \emph{Journal of Business & Economic Statistics},
\bold{13}(1), 105--111.

Hadri, K. 1999. Estimation of a doubly heteroscedastic stochastic frontier
cost function. \emph{Journal of Business & Economic Statistics},
\bold{17}(3), 359--363.

Meeusen, W., and J. Vandenbroeck. 1977. Efficiency estimation from
Cobb-Douglas production functions with composed error. \emph{International
Economic Review}, \bold{18}(2), 435--445.

Orea, L., and S.C. Kumbhakar. 2004. Efficiency measurement using a latent
class stochastic frontier model. \emph{Empirical Economics}, \bold{29},
169--183.

Parmeter, C.F., and S.C. Kumbhakar. 2014. Efficiency analysis: A primer on
recent advances. \emph{Foundations and Trends in Econometrics}, \bold{7},
191--385.

Reifschneider, D., and R. Stevenson. 1991. Systematic departures from the
frontier: A framework for the analysis of firm inefficiency.
\emph{International Economic Review}, \bold{32}(3), 715--723.
}
\seealso{
\code{\link[=print.sfalcmcross]{print}} for printing \code{sfalcmcross}
object.

\code{\link[=summary.sfalcmcross]{summary}} for creating and printing
summary results.

\code{\link[=coef.sfalcmcross]{coef}} for extracting coefficients of the
estimation.

\code{\link[=efficiencies.sfalcmcross]{efficiencies}} for computing
(in-)efficiency estimates.

\code{\link[=fitted.sfalcmcross]{fitted}} for extracting the fitted frontier
values.

\code{\link[=ic.sfalcmcross]{ic}} for extracting information criteria.

\code{\link[=logLik.sfalcmcross]{logLik}} for extracting log-likelihood
value(s) of the estimation.

\code{\link[=marginal.sfalcmcross]{marginal}} for computing marginal effects of
inefficiency drivers.

\code{\link[=residuals.sfalcmcross]{residuals}} for extracting residuals of the
estimation.

\code{\link[=vcov.sfalcmcross]{vcov}} for computing the variance-covariance
matrix of the coefficients.

\code{\link[=bread.sfalcmcross]{bread}} for bread for sandwich estimator.

\code{\link[=estfun.sfalcmcross]{estfun}} for gradient extraction for each
observation.
}
\keyword{cross-section}
\keyword{latent-class}
\keyword{likelihood}
\keyword{models}
\keyword{optimize}
